/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.util.Map;
import org.biopax.paxtools.io.sif.level3.ChangeType;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;

public class PEStateChange {
    Map<EntityFeature, ChangeType> deltaFeatures;
    Conversion conv;
    SimplePhysicalEntity left;
    SimplePhysicalEntity right;

    public PEStateChange(SimplePhysicalEntity left, SimplePhysicalEntity right, BioPAXElement element, Conversion conv) {
        this.left = left;
        this.right = right;
        this.conv = conv;
        this.deltaFeatures = ChangeType.getDeltaFeatures((PhysicalEntity)left, (PhysicalEntity)right);
    }

    public String toString() {
        return this.left.getStandardName() + "--" + this.right.getDisplayName() + "(" + this.deltaFeatures + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PEStateChange)) {
            return false;
        }
        PEStateChange that = (PEStateChange)o;
        if (this.conv != null ? !this.conv.equals(that.conv) : that.conv != null) {
            return false;
        }
        if (this.deltaFeatures != null ? !((Object)this.deltaFeatures).equals(that.deltaFeatures) : that.deltaFeatures != null) {
            return false;
        }
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        return !(this.right != null ? !this.right.equals(that.right) : that.right != null);
    }

    public Map<EntityFeature, ChangeType> getDeltaFeatures() {
        return this.deltaFeatures;
    }

    public Conversion getConv() {
        return this.conv;
    }

    public SimplePhysicalEntity getLeft() {
        return this.left;
    }

    public SimplePhysicalEntity getRight() {
        return this.right;
    }

    public int hashCode() {
        int result = this.deltaFeatures != null ? ((Object)this.deltaFeatures).hashCode() : 0;
        result = 31 * result + (this.conv != null ? this.conv.hashCode() : 0);
        result = 31 * result + (this.left != null ? this.left.hashCode() : 0);
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }
}

