/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.io.sif.level3.ChangeType;
import org.biopax.paxtools.io.sif.level3.GroupMap;
import org.biopax.paxtools.io.sif.level3.Grouper;
import org.biopax.paxtools.io.sif.level3.PEStateChange;
import org.biopax.paxtools.io.sif.level3.Simplify;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;

public class StateNetworkAnalyzer {
    Map<BioPAXElement, Set<PEStateChange>> stateChanges;

    public void analyzeStates(Model model) {
        GroupMap groupMap = Grouper.inferGroups(model);
        this.stateChanges = new HashMap<BioPAXElement, Set<PEStateChange>>();
        for (EntityReference pr : model.getObjects(EntityReference.class)) {
            for (SimplePhysicalEntity spe : pr.getEntityReferenceOf()) {
                for (Interaction interaction2 : spe.getParticipantOf()) {
                    if (!(interaction2 instanceof Conversion)) continue;
                    Conversion conv = (Conversion)interaction2;
                    Simplify.entityHasAChange((BioPAXElement)pr, conv, groupMap, this.stateChanges);
                }
            }
        }
    }

    public Set<SimplePhysicalEntity> getPrecedingStates(SimplePhysicalEntity spe) {
        HashSet<SimplePhysicalEntity> result = new HashSet<SimplePhysicalEntity>();
        EntityReference er = spe.getEntityReference();
        Set<PEStateChange> peStateChanges = this.stateChanges.get(er);
        for (PEStateChange peStateChange : peStateChanges) {
            if (!peStateChange.right.equals(spe)) continue;
            result.add(peStateChange.left);
        }
        return result;
    }

    public Set<PEStateChange> getAllStates(EntityReference er) {
        return this.stateChanges.get(er);
    }

    public Set<SimplePhysicalEntity> getSucceedingStates(SimplePhysicalEntity spe) {
        HashSet<SimplePhysicalEntity> result = new HashSet<SimplePhysicalEntity>();
        EntityReference er = spe.getEntityReference();
        Set<PEStateChange> peStateChanges = this.stateChanges.get(er);
        for (PEStateChange peStateChange : peStateChanges) {
            if (!peStateChange.left.equals(spe)) continue;
            result.add(peStateChange.right);
        }
        return result;
    }

    public void writeStateNetworkAnalysis(OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        for (BioPAXElement bpe : this.stateChanges.keySet()) {
            if (!(bpe instanceof EntityReference)) continue;
            EntityReference er = (EntityReference)bpe;
            writer.write("\nEntity:" + er.getName() + "Refs:" + er.getXref() + "\n");
            for (PEStateChange sChange : this.stateChanges.get(bpe)) {
                writer.write("\n STATE CHANGE\n");
                this.writeState(writer, sChange.left, "Left");
                this.writeState(writer, sChange.right, "Right");
                Map<EntityFeature, ChangeType> deltaFeatures = sChange.deltaFeatures;
                if (!deltaFeatures.isEmpty()) {
                    writer.write("\nFeatures that are changed:\n");
                }
                for (EntityFeature ef : deltaFeatures.keySet()) {
                    writer.write(ef + ":" + (Object)((Object)deltaFeatures.get(ef)) + "\n");
                }
            }
            writer.write("\n");
        }
        ((Writer)writer).flush();
    }

    private void writeState(Writer writer, SimplePhysicalEntity spe, String side) throws IOException {
        writer.write(side + ":" + spe.getName());
        boolean knownControl = false;
        for (CType cType : CType.values()) {
            Set<Control> controls = cType.getControls(spe);
            if (controls.isEmpty()) continue;
            if (!knownControl) {
                knownControl = true;
                writer.write("\nControls:\n");
            }
            writer.write((Object)((Object)cType) + ":");
            for (Control control2 : controls) {
                writer.write("\t\t" + control2.getControlType() + ":" + control2.getName() + "\n");
            }
        }
        writer.write("\n");
    }

    public static enum CType {
        DIRECT("SimplePhysicalEntity/controllerOf"),
        VIA_COMPLEX("SimplePhysicalEntity/componentOf*/controllerOf"),
        VIA_GENERIC("SimplePhysicalEntity/memberPhysicalEntityOf*/controllerOf");

        PathAccessor accessor;

        private CType(String s) {
            this.accessor = new PathAccessor(s);
        }

        public Set<Control> getControls(SimplePhysicalEntity spe) {
            return new HashSet<Control>(this.accessor.getValueFromBean((BioPAXElement)spe));
        }
    }
}

