/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import org.biopax.paxtools.controller.AbstractTraverser;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.util.Filter;
import org.biopax.validator.impl.AbstractRule;
import org.springframework.stereotype.Component;

@Component
public class AcyclicComplexRule
extends AbstractRule<Complex> {
    static final Filter<PropertyEditor> filter = new Filter<PropertyEditor>(){

        public boolean filter(PropertyEditor editor) {
            return editor.getProperty().equals("component");
        }
    };

    public boolean canCheck(Object thing) {
        return thing instanceof Complex;
    }

    public void check(final Complex thing, boolean fix) {
        AbstractTraverser traverser = new AbstractTraverser((EditorMap)SimpleEditorMap.L3, new Filter[]{filter}){

            protected void visit(Object range, BioPAXElement domain, Model model, PropertyEditor editor) {
                assert (range instanceof PhysicalEntity);
                if (thing.equals(range)) {
                    AcyclicComplexRule.this.error(thing, "cyclic.inclusion", false, new Object[]{this.getVisited().toString()});
                } else if (range instanceof Complex) {
                    this.traverse((BioPAXElement)((Complex)range), model);
                }
            }
        };
        traverser.traverse((BioPAXElement)thing, null);
    }
}

