/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import org.biopax.paxtools.controller.AbstractTraverser;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PathwayStep;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.util.Filter;
import org.biopax.validator.impl.AbstractRule;
import org.springframework.stereotype.Component;

@Component
public class AcyclicPathwayRule
extends AbstractRule<Pathway> {
    private static final Filter<PropertyEditor> filter = new Filter<PropertyEditor>(){

        public boolean filter(PropertyEditor editor) {
            return !"nextStep".equals(editor.getProperty());
        }
    };

    public boolean canCheck(Object thing) {
        return thing instanceof Pathway;
    }

    public void check(final Pathway thing, boolean fix) {
        AbstractTraverser checker = new AbstractTraverser((EditorMap)SimpleEditorMap.L3, new Filter[]{filter}){

            protected void visit(Object value, BioPAXElement bpe, Model model, PropertyEditor editor) {
                if (value instanceof Process || value instanceof PathwayStep) {
                    if (value instanceof Pathway && thing.getRDFId().equalsIgnoreCase(((Pathway)value).getRDFId())) {
                        AcyclicPathwayRule.this.error(thing, "cyclic.inclusion", false, new Object[]{this.getVisited().toString()});
                    } else {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Traverse into " + value + " " + value.getClass().getSimpleName()));
                        }
                        this.traverse((BioPAXElement)value, model);
                    }
                }
            }
        };
        checker.traverse((BioPAXElement)thing, null);
    }
}

