/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.BiochemicalReaction;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.Transport;
import org.biopax.validator.impl.AbstractRule;
import org.biopax.validator.utils.BiopaxValidatorUtils;
import org.springframework.stereotype.Component;

@Component
public class BiochemReactParticipantsLocationRule
extends AbstractRule<BiochemicalReaction> {
    public void check(BiochemicalReaction react, boolean fix) {
        Set left = react.getLeft();
        Set right = react.getRight();
        for (PhysicalEntity lefty : left) {
            for (PhysicalEntity righty : right) {
                boolean sameSimplePhysicalEntity;
                boolean sameComplex;
                if (!lefty.getModelInterface().equals(righty.getModelInterface())) continue;
                boolean bl = sameComplex = lefty instanceof Complex && !BiopaxValidatorUtils.namesInCommon((Named)lefty, (Named)righty).isEmpty();
                boolean bl2 = lefty instanceof SimplePhysicalEntity && (((SimplePhysicalEntity)lefty).getEntityReference() == null ? ((SimplePhysicalEntity)righty).getEntityReference() == null : ((SimplePhysicalEntity)lefty).getEntityReference().isEquivalent((BioPAXElement)((SimplePhysicalEntity)righty).getEntityReference())) ? true : (sameSimplePhysicalEntity = false);
                if (!sameComplex && !sameSimplePhysicalEntity) continue;
                boolean sameLoc = lefty.hasEquivalentCellularLocation(righty);
                if (!sameLoc && !(react instanceof Transport)) {
                    this.error(react, "participant.location.changed", false, new Object[]{lefty, righty});
                    continue;
                }
                if (!sameLoc || !(react instanceof Transport)) continue;
                this.error(react, "transport.location.same", false, new Object[]{lefty, righty});
            }
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof BiochemicalReaction;
    }
}

