/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import org.biopax.paxtools.model.level3.BiochemicalPathwayStep;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.CatalysisDirectionType;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.validator.impl.AbstractRule;
import org.springframework.stereotype.Component;

@Component
public class BiochemicalPathwayStepAndCatalysisDirectionRule
extends AbstractRule<BiochemicalPathwayStep> {
    private void fix(BiochemicalPathwayStep t, Object ... values) {
        if (values[0] instanceof Catalysis) {
            ((Catalysis)values[0]).setCatalysisDirection((CatalysisDirectionType)values[1]);
        } else if (values[0] instanceof Conversion) {
            ((Conversion)values[0]).setConversionDirection((ConversionDirectionType)values[1]);
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof BiochemicalPathwayStep;
    }

    public void check(BiochemicalPathwayStep step, boolean fix) {
        if (step != null && step.getStepDirection() != null) {
            for (Process proc : step.getStepProcess()) {
                CatalysisDirectionType cdir;
                if (!(proc instanceof Catalysis) || (cdir = ((Catalysis)proc).getCatalysisDirection()) == null || cdir == CatalysisDirectionType.LEFT_TO_RIGHT) continue;
                this.error(step, "direction.conflict", fix, new Object[]{"stepDirection=" + step.getStepDirection(), proc, "catalysisDirection=" + cdir + ", must be LEFT_TO_RIGHT"});
                if (!fix) continue;
                this.fix(step, proc, null);
            }
            Conversion con = step.getStepConversion();
            if (con != null && con.getConversionDirection() != null && con.getConversionDirection() != ConversionDirectionType.REVERSIBLE) {
                this.error(step, "direction.conflict", fix, new Object[]{"stepDirection=" + step.getStepDirection(), con, "conversionDirection=" + con.getConversionDirection() + ", must be REVERSIBLE or empty"});
                if (fix) {
                    this.fix(step, con, ConversionDirectionType.REVERSIBLE);
                }
            }
        }
    }
}

