/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.net.URI;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.validator.impl.AbstractRule;
import org.springframework.stereotype.Component;

@Component
public class BiopaxElementIdRule
extends AbstractRule<BioPAXElement> {
    public boolean canCheck(Object thing) {
        return thing instanceof BioPAXElement;
    }

    public void check(BioPAXElement thing, boolean fix) {
        String rdfid = thing.getRDFId();
        if (rdfid != null) {
            try {
                URI.create(rdfid);
            }
            catch (IllegalArgumentException e) {
                this.error(thing, "invalid.rdf.id", false, new Object[]{"not a valid URI: " + rdfid});
            }
        } else {
            this.error(thing, "invalid.rdf.id", false, new Object[]{"null value"});
        }
    }
}

