/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Collection;
import org.apache.commons.collections15.set.CompositeSet;
import org.biopax.paxtools.controller.AbstractTraverser;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.UtilityClass;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.Filter;
import org.biopax.validator.impl.AbstractRule;
import org.biopax.validator.utils.BiopaxValidatorUtils;
import org.biopax.validator.utils.Cluster;
import org.springframework.stereotype.Component;

@Component
public class ClonedUtilityClassRule
extends AbstractRule<Model> {
    public void check(Model model, boolean fix) {
        Object[] peers = model.getObjects(UtilityClass.class).toArray(new UtilityClass[0]);
        Cluster<UtilityClass> algorithm = new Cluster<UtilityClass>(){

            public boolean match(UtilityClass a, UtilityClass b) {
                return !a.equals(b) && a.isEquivalent((BioPAXElement)b);
            }
        };
        CompositeSet clasters = algorithm.groupByEquivalence(peers, BiopaxValidatorUtils.maxErrors);
        for (Collection duplicates : clasters.getCollections()) {
            UtilityClass u = (UtilityClass)duplicates.iterator().next();
            duplicates.remove(u);
            this.error(u, "cloned.utility.class", fix, new Object[]{BiopaxValidatorUtils.getIdListAsString((Collection)duplicates), u.getModelInterface().getSimpleName()});
            if (!fix) continue;
            this.fix(model, u, duplicates);
        }
        if (fix) {
            for (UtilityClass duplicate : clasters.toCollection()) {
                model.remove((BioPAXElement)duplicate);
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info((Object)("Duplicate object " + duplicate.getRDFId() + " " + duplicate.getModelInterface().getSimpleName() + " has been removed from the model" + " and all object properties updated!"));
            }
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof Model && ((Model)thing).getLevel() == BioPAXLevel.L3;
    }

    private void fix(Model model, final UtilityClass master, final Collection<UtilityClass> clones) {
        if (master != null) {
            AbstractTraverser traverser = new AbstractTraverser((EditorMap)SimpleEditorMap.L3, new Filter[0]){

                protected void visit(Object range, BioPAXElement domain, Model model, PropertyEditor editor) {
                    if (editor instanceof ObjectPropertyEditor && clones.contains(range)) {
                        if (!master.isEquivalent((BioPAXElement)((UtilityClass)range))) {
                            ClonedUtilityClassRule.this.logger.error((Object)(master + " (" + master.getRDFId() + ", " + master.getModelInterface().getSimpleName() + ") replaces NOT semantically equivalent " + range + " (" + ((UtilityClass)range).getRDFId() + ", " + ((UtilityClass)range).getModelInterface().getSimpleName() + ")! Ignored..."));
                        }
                        if (editor.isMultipleCardinality()) {
                            editor.removeValueFromBean(range, domain);
                        }
                        editor.setValueToBean((Object)master, domain);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Replaced " + ((UtilityClass)range).getModelInterface().getSimpleName() + " " + ((UtilityClass)range).getRDFId() + " with " + master.getRDFId() + "; " + editor.toString() + "; (domain) bean: " + domain));
                        }
                    }
                }
            };
            for (BioPAXElement element : model.getObjects()) {
                traverser.traverse(element, model);
            }
            for (UtilityClass clone : clones) {
                if (clone instanceof Xref ? !$assertionsDisabled && !((Xref)clone).getXrefOf().isEmpty() : clone instanceof EntityReference && !$assertionsDisabled && !((EntityReference)clone).getEntityReferenceOf().isEmpty()) {
                    throw new AssertionError();
                }
            }
        }
    }
}

