/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Collections;
import java.util.Set;
import org.biopax.paxtools.model.level3.BindingFeature;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.ComplexAssembly;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.validator.impl.AbstractRule;
import org.springframework.stereotype.Component;

@Component
public class ComplexAssemblyHasComplexParticipantRule
extends AbstractRule<ComplexAssembly> {
    public void check(ComplexAssembly complexAssembly, boolean fix) {
        ClassFilterSet complexes = new ClassFilterSet(complexAssembly.getParticipant(), Complex.class);
        if (complexes.isEmpty()) {
            boolean bound = this.isBound(complexAssembly.getRight());
            if (!bound) {
                bound = this.isBound(complexAssembly.getLeft());
            }
            if (!bound) {
                this.error(complexAssembly, "complex.not.present", false, new Object[0]);
            }
        }
    }

    private boolean isBound(Set<PhysicalEntity> participants) {
        for (PhysicalEntity pe : participants) {
            Set bf2Of;
            BindingFeature bf1;
            BindingFeature bf2;
            if (pe.getFeature() == null || !(pe.getFeature() instanceof BindingFeature) || (bf2 = (bf1 = (BindingFeature)pe.getFeature()).getBindsTo()) == null || Collections.disjoint(participants, bf2Of = bf2.getFeatureOf())) continue;
            return true;
        }
        return false;
    }

    public boolean canCheck(Object thing) {
        return thing instanceof ComplexAssembly;
    }
}

