/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.validator.impl.AbstractRule;
import org.springframework.stereotype.Component;

@Component
public class ComplexComponentsMultipleLocationRule
extends AbstractRule<Complex> {
    public void check(Complex thing, boolean fix) {
        Set ents = thing.getComponent();
        if (ents != null) {
            HashSet<String> diffLocs = new HashSet<String>();
            Complex ref = thing;
            for (PhysicalEntity e : ents) {
                if (ref.getCellularLocation() == null && e.getCellularLocation() != null) {
                    ref = e;
                    continue;
                }
                if (e.getCellularLocation() == null || ref.getCellularLocation().isEquivalent((BioPAXElement)e.getCellularLocation())) continue;
                diffLocs.add(e + " " + e.getCellularLocation());
            }
            if (!diffLocs.isEmpty()) {
                this.error(thing, "component.different.location", false, new Object[]{thing.getCellularLocation() + "", diffLocs});
            }
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof Complex;
    }
}

