/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.validator.impl.AbstractRule;
import org.springframework.stereotype.Component;

@Component
public class ComplexComponentsSameLocationRule
extends AbstractRule<Complex> {
    public boolean canCheck(Object thing) {
        return thing instanceof Complex;
    }

    public void check(Complex thing, boolean fix) {
        Set ents;
        if (thing.getCellularLocation() != null && (ents = thing.getComponent()) != null) {
            HashSet<String> comps = new HashSet<String>();
            for (PhysicalEntity e : ents) {
                if (e.getCellularLocation() != null) continue;
                comps.add(e + " " + e.getCellularLocation());
            }
            if (!comps.isEmpty()) {
                this.error(thing, "component.no.location", false, new Object[]{thing.getCellularLocation().toString(), comps});
            }
        }
    }
}

