/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Collection;
import org.apache.commons.collections15.set.CompositeSet;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.validator.impl.AbstractRule;
import org.biopax.validator.utils.BiopaxValidatorUtils;
import org.biopax.validator.utils.Cluster;
import org.springframework.stereotype.Component;

@Component
public class DuplicateIdCaseInsensitiveRule
extends AbstractRule<Model> {
    public void check(Model model, boolean fix) {
        Object[] peers = model.getObjects().toArray(new BioPAXElement[0]);
        Cluster<BioPAXElement> algorithm = new Cluster<BioPAXElement>(){

            public boolean match(BioPAXElement a, BioPAXElement b) {
                return !a.equals(b) && a.getRDFId().equalsIgnoreCase(b.getRDFId());
            }
        };
        CompositeSet clasters = algorithm.groupByEquivalence(peers, Integer.MAX_VALUE);
        for (Collection duplicates : clasters.getCollections()) {
            BioPAXElement u = (BioPAXElement)duplicates.iterator().next();
            duplicates.remove(u);
            this.error(u, "duplicate.id.ignoringcase", fix, new Object[]{BiopaxValidatorUtils.getIdListAsString((Collection)duplicates), u.getModelInterface().getSimpleName()});
            if (!fix) continue;
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof Model;
    }
}

