/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.validator.impl.AbstractRule;
import org.springframework.stereotype.Component;

@Component
public class EntityReferenceXrefRule
extends AbstractRule<EntityReference> {
    public void check(EntityReference er, boolean fix) {
        if (er.getMemberEntityReference().isEmpty()) {
            if (er.getXref().isEmpty()) {
                this.error(er, "no.xrefs", false, new Object[0]);
            } else {
                boolean present = false;
                for (Xref x : er.getXref()) {
                    Class face = x.getModelInterface();
                    if (!UnificationXref.class.equals((Object)face)) continue;
                    present = true;
                }
                if (!present) {
                    this.error(er, "no.unification.xref", false, new Object[0]);
                }
            }
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof EntityReference;
    }
}

