/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Collection;
import java.util.HashSet;
import org.biopax.paxtools.model.level3.BiochemicalPathwayStep;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.Gene;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PathwayStep;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.validator.impl.AbstractRule;
import org.springframework.stereotype.Component;

@Component
public class NextStepShareParticipantsRule
extends AbstractRule<PathwayStep> {
    public boolean canCheck(Object thing) {
        return thing instanceof PathwayStep && !((PathwayStep)thing).getNextStepOf().isEmpty();
    }

    public void check(PathwayStep step, boolean fix) {
        if (step.getNextStepOf().isEmpty()) {
            return;
        }
        Collection<Entity> thisStepParticipants = this.getParticipants(step);
        for (PathwayStep prevStep : step.getNextStepOf()) {
            Collection<Entity> participants = this.getParticipants(prevStep);
            participants.retainAll(thisStepParticipants);
            if (!participants.isEmpty()) continue;
            this.error(step, "empty.participants.intersection", false, new Object[]{prevStep});
        }
    }

    Collection<Entity> getParticipants(PathwayStep step) {
        HashSet<Process> processes = new HashSet<Process>();
        HashSet<Entity> ret = new HashSet<Entity>();
        if (step instanceof BiochemicalPathwayStep) {
            Conversion c = ((BiochemicalPathwayStep)step).getStepConversion();
            ret.addAll(this.getParticipants((Process)c, processes));
        }
        for (Process p : step.getStepProcess()) {
            ret.addAll(this.getParticipants(p, processes));
        }
        return ret;
    }

    Collection<Entity> getParticipants(Process process2, Collection<Process> visited) {
        HashSet<Entity> ret = new HashSet<Entity>();
        if (visited.contains(process2)) {
            return ret;
        }
        visited.add(process2);
        if (process2 instanceof Interaction) {
            for (Entity pat : ((Interaction)process2).getParticipant()) {
                if (!(pat instanceof PhysicalEntity) && !(pat instanceof Gene)) continue;
                ret.add(pat);
            }
        } else {
            for (Process p : ((Pathway)process2).getPathwayComponent()) {
                ret.addAll(this.getParticipants(p, visited));
            }
        }
        return ret;
    }

    private void fix(PathwayStep t, Object ... values) {
    }
}

