/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level2.conversion;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.validator.impl.AbstractRule;
import org.springframework.stereotype.Component;

@Component
public class NotAdvisedInstancesRule
extends AbstractRule<BioPAXElement> {
    static final Class[] NOT_ADVISED = new Class[]{Control.class, Conversion.class, Interaction.class, EntityFeature.class, PhysicalEntity.class, physicalEntity.class, conversion.class};

    private boolean notAllowed(Object o) {
        if (o instanceof BioPAXElement) {
            for (int i = 0; i < NOT_ADVISED.length; ++i) {
                if (!((BioPAXElement)o).getModelInterface().equals(NOT_ADVISED[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canCheck(Object thing) {
        return this.notAllowed(thing);
    }

    public void check(BioPAXElement thing, boolean fix) {
        this.error(thing, "not.specific.element", false, new Object[]{thing.getModelInterface().getSimpleName()});
    }
}

