/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.validator.impl.AbstractRule;
import org.biopax.validator.utils.XrefHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProvenanceRule
extends AbstractRule<Provenance> {
    @Autowired
    XrefHelper xrefHelper;

    public boolean canCheck(Object thing) {
        return thing instanceof Provenance;
    }

    public void check(Provenance p, boolean fix) {
        String db = null;
        if (p.getStandardName() != null) {
            db = this.xrefHelper.getPrimaryDbName(p.getStandardName());
        }
        if (db == null) {
            if (p.getDisplayName() != null) {
                db = this.xrefHelper.getPrimaryDbName(p.getDisplayName());
                if (db == null) {
                    this.error(p, "unknown.db", false, new Object[]{p.getDisplayName() + " or " + p.getStandardName()});
                }
            } else {
                this.error(p, "cardinality.violated", false, new Object[]{"standardName or displayName", 1});
            }
        }
        for (Xref x : p.getXref()) {
            if (!(x instanceof UnificationXref)) continue;
            this.error(x, "not.allowed.xref", false, new Object[]{x.getDb(), p, "Provenance", "- Miriam or PubMed but not a bioentities db!"});
        }
    }
}

