/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.HashSet;
import org.biopax.paxtools.controller.AbstractTraverser;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.ComplexAssembly;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Degradation;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.paxtools.util.Filter;
import org.biopax.validator.impl.AbstractRule;
import org.springframework.stereotype.Component;

@Component
public class SimplePhysicalEntityConversionRule
extends AbstractRule<SimplePhysicalEntity> {
    public void check(SimplePhysicalEntity protein, boolean fix) {
        HashSet conversions = new HashSet(new ClassFilterSet(protein.getParticipantOf(), Conversion.class));
        for (Conversion conversion2 : conversions) {
            String side;
            if (conversion2 instanceof ComplexAssembly || conversion2 instanceof Degradation || this.findProteinOnTheOtherSide(conversion2, protein, side = conversion2.getLeft().contains(protein) ? "right" : "left")) continue;
            this.error(protein, "illegal.conversion", false, new Object[]{conversion2, side});
        }
    }

    boolean findProteinOnTheOtherSide(Conversion conversion2, final SimplePhysicalEntity prot, final String side) {
        AbstractTraverser runner = new AbstractTraverser((EditorMap)SimpleEditorMap.L3, new Filter[0]){

            protected void visit(Object value, BioPAXElement parent, Model model, PropertyEditor editor) {
                if (!editor.getProperty().equals(side)) {
                    return;
                }
                if (value instanceof SimplePhysicalEntity && ((SimplePhysicalEntity)value).getEntityReference() != null && ((SimplePhysicalEntity)value).getEntityReference().isEquivalent((BioPAXElement)prot.getEntityReference())) {
                    throw new RuntimeException("found!");
                }
                if (value instanceof Complex) {
                    this.traverse((BioPAXElement)((Complex)value), model);
                }
            }
        };
        try {
            runner.traverse((BioPAXElement)conversion2, null);
        }
        catch (RuntimeException e) {
            return true;
        }
        return false;
    }

    public boolean canCheck(Object thing) {
        return thing instanceof SimplePhysicalEntity && !(thing instanceof SmallMolecule);
    }
}

