/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.validator.impl.AbstractRule;
import org.biopax.validator.utils.XrefHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UnificationXrefLimitedRule
extends AbstractRule<UnificationXref> {
    private Map<Class<BioPAXElement>, Set<String>> allow;
    private Map<Class<BioPAXElement>, Set<String>> deny;
    private XrefHelper helper;

    @Resource(name="dbAllow")
    public void setDbAllow(Map<Class<BioPAXElement>, String> dbAllow) {
        this.allow = new HashMap<Class<BioPAXElement>, Set<String>>();
        for (Class<BioPAXElement> clazz : dbAllow.keySet()) {
            String[] a = dbAllow.get(clazz).toLowerCase().split(":");
            HashSet allSynonyms = new HashSet();
            for (String db : a) {
                List synonymsOfDb = this.helper.getSynonymsForDbName(db);
                allSynonyms.addAll(synonymsOfDb);
            }
            this.allow.put(clazz, allSynonyms);
        }
    }

    @Resource(name="dbDeny")
    public void setDbDeny(Map<Class<BioPAXElement>, String> dbDeny) {
        this.deny = new HashMap<Class<BioPAXElement>, Set<String>>();
        for (Class<BioPAXElement> clazz : dbDeny.keySet()) {
            String[] a = dbDeny.get(clazz).toLowerCase().split(":");
            HashSet allSynonyms = new HashSet();
            for (String db : a) {
                List synonymsOfDb = this.helper.getSynonymsForDbName(db);
                allSynonyms.addAll(synonymsOfDb);
            }
            this.deny.put(clazz, allSynonyms);
        }
    }

    @Autowired
    public UnificationXrefLimitedRule(XrefHelper xrefHelper) {
        this.helper = xrefHelper;
    }

    public boolean canCheck(Object thing) {
        return thing instanceof UnificationXref;
    }

    public void check(UnificationXref x, boolean fix) {
        if (x.getDb() == null || this.helper.getPrimaryDbName(x.getDb()) == null) {
            return;
        }
        String xdb = this.helper.dbName(x.getDb());
        for (XReferrable bpe : x.getXrefOf()) {
            for (Class<BioPAXElement> c : this.allow.keySet()) {
                if (!c.isInstance(bpe) || this.allow.get(c).contains(xdb)) continue;
                this.error(x, "not.allowed.xref", false, new Object[]{x.getDb(), bpe, c.getSimpleName(), this.allow.get(c).toString()});
            }
            for (Class<BioPAXElement> c : this.deny.keySet()) {
                if (!c.isInstance(bpe) || !this.deny.get(c).contains(xdb)) continue;
                this.error(x, "denied.xref", false, new Object[]{x.getDb(), bpe, c.getSimpleName(), this.deny.get(c).toString()});
            }
        }
    }
}

