/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.conversion;
import org.biopax.paxtools.model.level2.entity;
import org.biopax.paxtools.model.level2.pathwayStep;
import org.biopax.paxtools.model.level2.protein;
import org.biopax.validator.rules.BiochemPathwayStepOneConversionRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Level2RulesUnitTest {
    BioPAXFactory level2;
    BioPAXIOHandler exporter;
    static final String TEST_DATA_DIR = Level2RulesUnitTest.class.getResource("").getPath();

    void writeExample(String file, Model model) {
        try {
            this.exporter.convertToOWL(model, (OutputStream)new FileOutputStream(TEST_DATA_DIR + File.separator + file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Before
    public void setUp() {
        this.level2 = BioPAXLevel.L2.getDefaultFactory();
        this.exporter = new SimpleIOHandler(BioPAXLevel.L2);
    }

    @Test
    public void testCanCheck() {
        BiochemPathwayStepOneConversionRule rule = new BiochemPathwayStepOneConversionRule();
        pathwayStep pstep = (pathwayStep)this.level2.create(pathwayStep.class, "1");
        BioPAXElement bpe = this.level2.create(conversion.class, "2");
        entity ent = (entity)this.level2.create(protein.class, "3");
        Assert.assertFalse((boolean)rule.canCheck(null));
        Assert.assertFalse((boolean)rule.canCheck((Object)ent));
        Assert.assertFalse((boolean)rule.canCheck((Object)pstep));
        Assert.assertFalse((boolean)rule.canCheck((Object)bpe));
    }
}

