/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.BiochemicalPathwayStep;
import org.biopax.paxtools.model.level3.BiochemicalReaction;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.ComplexAssembly;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.Degradation;
import org.biopax.paxtools.model.level3.Dna;
import org.biopax.paxtools.model.level3.DnaReference;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.FragmentFeature;
import org.biopax.paxtools.model.level3.Level3Element;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.PathwayStep;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.biopax.paxtools.model.level3.Rna;
import org.biopax.paxtools.model.level3.RnaReference;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.Stoichiometry;
import org.biopax.paxtools.model.level3.TemplateReactionRegulation;
import org.biopax.paxtools.model.level3.TransportWithBiochemicalReaction;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.validator.rules.AcyclicComplexRule;
import org.biopax.validator.rules.BiochemPathwayStepOneConversionRule;
import org.biopax.validator.rules.BiochemReactParticipantsLocationRule;
import org.biopax.validator.rules.BiochemicalPathwayStepProcessOnlyControlCRRule;
import org.biopax.validator.rules.BiopaxElementIdRule;
import org.biopax.validator.rules.ClonedUtilityClassRule;
import org.biopax.validator.rules.ControlTypeRule;
import org.biopax.validator.rules.ConversionStoichiometryCheckRule;
import org.biopax.validator.rules.ConversionToComplexAssemblyRule;
import org.biopax.validator.rules.DegradationConversionDirectionRule;
import org.biopax.validator.rules.DuplicateIdCaseInsensitiveRule;
import org.biopax.validator.rules.EntityReferenceSamePhysicalEntitiesRule;
import org.biopax.validator.rules.PhysicalEntityAmbiguousFeatureRule;
import org.biopax.validator.rules.ProteinReferenceOrganismRule;
import org.biopax.validator.rules.SharedUnificationXrefRule;
import org.biopax.validator.rules.SimplePhysicalEntityFeaturesRule;
import org.biopax.validator.utils.BiopaxValidatorException;
import org.junit.Assert;
import org.junit.Test;

public class Level3RulesUnitTest {
    static BioPAXFactory level3 = BioPAXLevel.L3.getDefaultFactory();
    static EditorMap editorMap = SimpleEditorMap.L3;
    static BioPAXIOHandler exporter = new SimpleIOHandler(BioPAXLevel.L3);
    static final String TEST_DATA_DIR = Level3RulesUnitTest.class.getResource("").getPath();

    void writeExample(String file, Model model) {
        try {
            exporter.convertToOWL(model, (OutputStream)new FileOutputStream(TEST_DATA_DIR + File.separator + file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testBiochemicalPathwayStepProcessOnlyControlCRRule() throws IOException {
        BiochemicalPathwayStepProcessOnlyControlCRRule rule = new BiochemicalPathwayStepProcessOnlyControlCRRule();
        BiochemicalPathwayStep step = (BiochemicalPathwayStep)level3.create(BiochemicalPathwayStep.class, "step1");
        Conversion conv = (Conversion)level3.create(BiochemicalReaction.class, "interaction1");
        conv.addComment("a conversion reaction (not Control)");
        step.addStepProcess((Process)conv);
        step.addComment("error: has not a Control type step process");
        try {
            rule.check((Object)step, false);
            Assert.fail((String)"must throw BiopaxValidatorException");
        }
        catch (BiopaxValidatorException e) {
            Model m = level3.createModel();
            m.add((BioPAXElement)conv);
            m.add((BioPAXElement)step);
            this.writeExample("testBiochemicalPathwayStepProcessOnlyControlCRRule.owl", m);
        }
    }

    @Test
    public void testCanCheckBiochemPathwayStepOneConversionRule() {
        BiochemPathwayStepOneConversionRule rule = new BiochemPathwayStepOneConversionRule();
        BiochemicalPathwayStep bpstep = (BiochemicalPathwayStep)level3.create(BiochemicalPathwayStep.class, "1");
        BioPAXElement bpstepElement = level3.create(BiochemicalPathwayStep.class, "2");
        PathwayStep pstep = (PathwayStep)level3.create(PathwayStep.class, "3");
        BioPAXElement bpe = level3.create(Conversion.class, "4");
        Assert.assertFalse((boolean)rule.canCheck(null));
        Assert.assertFalse((boolean)rule.canCheck(new Object()));
        Assert.assertFalse((boolean)rule.canCheck((Object)pstep));
        Assert.assertFalse((boolean)rule.canCheck((Object)bpe));
        Assert.assertTrue((boolean)rule.canCheck((Object)bpstep));
        Assert.assertTrue((boolean)rule.canCheck((Object)bpstepElement));
    }

    @Test
    public void testBiochemPathwayStepOneConversionRule() throws IOException {
        BiochemPathwayStepOneConversionRule rule = new BiochemPathwayStepOneConversionRule();
        BiochemicalPathwayStep step = (BiochemicalPathwayStep)level3.create(BiochemicalPathwayStep.class, "step1");
        step.addComment("error: conversion cannot be a step process (only stepConversion)");
        Conversion conv = (Conversion)level3.create(BiochemicalReaction.class, "conversion1");
        step.setStepConversion(conv);
        rule.check((Object)step, false);
        Catalysis catalysis = (Catalysis)level3.create(Catalysis.class, "catalysis1");
        catalysis.addComment("valid step process value");
        step.addStepProcess((Process)catalysis);
        rule.check((Object)step, false);
        step.addStepProcess((Process)conv);
        try {
            rule.check((Object)step, false);
            Assert.fail((String)"must throw BiopaxValidatorException");
        }
        catch (BiopaxValidatorException e) {
            Model m = level3.createModel();
            m.add((BioPAXElement)step);
            m.add((BioPAXElement)conv);
            m.add((BioPAXElement)catalysis);
            this.writeExample("testBiochemPathwayStepOneConversionRule.owl", m);
        }
    }

    @Test
    public void testBiochemReactParticipantsLocationRule() throws IOException {
        BiochemReactParticipantsLocationRule rule = new BiochemReactParticipantsLocationRule();
        BiochemicalReaction reaction = (BiochemicalReaction)level3.create(BiochemicalReaction.class, "#BiochemicalReaction");
        Dna left = (Dna)level3.create(Dna.class, "#dna");
        Dna right = (Dna)level3.create(Dna.class, "#modifiedDna");
        EntityFeature feature = (EntityFeature)level3.create(FragmentFeature.class, "feature1");
        right.addFeature(feature);
        right.addComment("modified dna");
        DnaReference dnaReference = (DnaReference)level3.create(DnaReference.class, "#dnaref");
        left.setEntityReference((EntityReference)dnaReference);
        right.setEntityReference((EntityReference)dnaReference);
        CellularLocationVocabulary cl = (CellularLocationVocabulary)level3.create(CellularLocationVocabulary.class, "#cl");
        CellularLocationVocabulary cr = (CellularLocationVocabulary)level3.create(CellularLocationVocabulary.class, "#cr");
        cl.addTerm("cytoplasm");
        cr.addTerm("membrane");
        left.addName("dnaLeft");
        right.addName("dnaRight");
        reaction.addLeft((PhysicalEntity)left);
        reaction.addRight((PhysicalEntity)right);
        left.setCellularLocation(cl);
        right.setCellularLocation(cl);
        rule.check((Object)reaction, false);
        PhysicalEntity leftc = (PhysicalEntity)level3.create(Complex.class, "#complex");
        PhysicalEntity rightc = (PhysicalEntity)level3.create(Complex.class, "#modifiedCmplex");
        leftc.addName("cplx1");
        rightc.addName("cplx1");
        rightc.setCellularLocation(cl);
        reaction.addLeft(leftc);
        reaction.addRight(rightc);
        leftc.setCellularLocation(cr);
        leftc.addComment("location changed without transport?");
        try {
            rule.check((Object)reaction, false);
            Assert.fail((String)"must throw BiopaxValidatorException");
        }
        catch (BiopaxValidatorException e) {
            // empty catch block
        }
        leftc.removeName("cplx1");
        leftc.addName("cplx2");
        rule.check((Object)reaction, false);
        right.setCellularLocation(cr);
        right.addComment("location changed without transport?");
        try {
            rule.check((Object)reaction, false);
            Assert.fail((String)"must throw BiopaxValidatorException");
        }
        catch (BiopaxValidatorException e) {
            Model m = level3.createModel();
            m.add((BioPAXElement)reaction);
            m.add((BioPAXElement)left);
            m.add((BioPAXElement)right);
            m.add((BioPAXElement)dnaReference);
            m.add((BioPAXElement)cl);
            m.add((BioPAXElement)cr);
            m.add((BioPAXElement)feature);
            m.add((BioPAXElement)leftc);
            m.add((BioPAXElement)rightc);
            this.writeExample("testBiochemReactParticipantsLocationRule.owl", m);
        }
        leftc.removeName("cplx2");
        leftc.addName("cplx1");
        leftc.setCellularLocation(cr);
        rightc.setCellularLocation(cr);
        right.setCellularLocation(cr);
        left.setCellularLocation(cr);
        rule.check((Object)reaction, false);
    }

    @Test
    public void testBiochemReactParticipantsLocationRule_Transport() throws IOException {
        BiochemReactParticipantsLocationRule rule = new BiochemReactParticipantsLocationRule();
        BiochemicalReaction reaction = (BiochemicalReaction)level3.create(TransportWithBiochemicalReaction.class, "#transportWithBiochemicalReaction");
        reaction.addComment("This Transport contains one Rna that did not change its cellular location (error!) and another one that did not have any (which is now ok)");
        Model m = level3.createModel();
        m.add((BioPAXElement)reaction);
        Rna left = (Rna)level3.create(Rna.class, "#Rna1");
        Rna right = (Rna)level3.create(Rna.class, "#modRna1");
        EntityFeature feature = (EntityFeature)level3.create(ModificationFeature.class, "feature1");
        right.addFeature(feature);
        right.addComment("modified");
        RnaReference rnaReference = (RnaReference)level3.create(RnaReference.class, "#rnaRef");
        left.setEntityReference((EntityReference)rnaReference);
        right.setEntityReference((EntityReference)rnaReference);
        CellularLocationVocabulary cl = (CellularLocationVocabulary)level3.create(CellularLocationVocabulary.class, "#cl");
        CellularLocationVocabulary cr = (CellularLocationVocabulary)level3.create(CellularLocationVocabulary.class, "#cr");
        cl.addTerm("nucleus");
        cr.addTerm("cytoplasm");
        left.setDisplayName("rnaLeft1");
        right.setDisplayName("rnaRight1");
        reaction.addLeft((PhysicalEntity)left);
        reaction.addRight((PhysicalEntity)right);
        left.setCellularLocation(cl);
        right.setCellularLocation(cr);
        rule.check((Object)reaction, false);
        right.setCellularLocation(cl);
        try {
            rule.check((Object)reaction, false);
            Assert.fail((String)"must throw BiopaxValidatorException");
        }
        catch (BiopaxValidatorException e) {
            m.add((BioPAXElement)left);
            m.add((BioPAXElement)right);
            m.add((BioPAXElement)rnaReference);
            m.add((BioPAXElement)cl);
            m.add((BioPAXElement)cr);
            m.add((BioPAXElement)feature);
        }
        right = (Rna)level3.create(Rna.class, "#Rna2");
        left = (Rna)level3.create(Rna.class, "#modRna2");
        left.addFeature(feature);
        left.addComment("modified");
        left.setEntityReference((EntityReference)rnaReference);
        right.setEntityReference((EntityReference)rnaReference);
        left.setDisplayName("rnaLeft2");
        right.setDisplayName("rnaRight2");
        reaction.addLeft((PhysicalEntity)left);
        reaction.addRight((PhysicalEntity)right);
        right.setCellularLocation(cr);
        m.add((BioPAXElement)left);
        m.add((BioPAXElement)right);
        this.writeExample("testBiochemReactParticipantsLocationRule_Transport.owl", m);
        right = (Rna)m.getByID("#modRna1");
        right.setCellularLocation(cr);
        rule.check((Object)reaction, false);
    }

    @Test
    public void testBiopaxElementIdRule() throws IOException {
        BiopaxElementIdRule rule = new BiopaxElementIdRule();
        Level3Element bpe = (Level3Element)level3.create(UnificationXref.class, "http://www.biopax.org/UnificationXref#Taxonomy_40674");
        bpe.addComment("This is a valid ID");
        rule.check((Object)bpe, false);
        Model m = level3.createModel();
        m.add((BioPAXElement)bpe);
        bpe = (Level3Element)level3.create(UnificationXref.class, "Taxonomy UnificationXref_40674");
        bpe.addComment("Invalid ID (has a space)");
        try {
            rule.check((Object)bpe, false);
            Assert.fail((String)"must throw BiopaxValidatorException");
        }
        catch (BiopaxValidatorException e) {
            m.add((BioPAXElement)bpe);
        }
        this.writeExample("testBiopaxElementIdRule.owl", m);
        URI.create("#a");
        URI.create("a,b,c");
    }

    @Test
    public void testDuplicateNamesByExporter() throws IOException {
        Protein p = (Protein)level3.create(Protein.class, "myProtein");
        String name = "aDisplayName";
        p.setDisplayName(name);
        p.addComment("Display Name should not be repeated again in the Name property!");
        Model m = level3.createModel();
        m.add((BioPAXElement)p);
        this.writeExample("testDuplicateNamesByExporter.xml", m);
        BufferedReader in = new BufferedReader(new FileReader(TEST_DATA_DIR + File.separator + "testDuplicateNamesByExporter.xml"));
        char[] buf = new char[1000];
        in.read(buf);
        String xml = new String(buf);
        if (xml.indexOf(name) != xml.lastIndexOf(name)) {
            Assert.fail((String)"displayName gets duplicated by the SimpleExporter!");
        }
    }

    @Test
    public void testProteinReferenceOrganismRule() throws IOException {
        ProteinReferenceOrganismRule rule = new ProteinReferenceOrganismRule();
        BioSource bioSource = (BioSource)level3.create(BioSource.class, "BioSource-Human");
        bioSource.setDisplayName("Homo sapiens");
        UnificationXref taxonXref = (UnificationXref)level3.create(UnificationXref.class, "Taxonomy_UnificationXref_9606");
        taxonXref.setDb("taxonomy");
        taxonXref.setId("9606");
        bioSource.addXref((Xref)taxonXref);
        ProteinReference pr = (ProteinReference)level3.create(ProteinReference.class, "ProteinReference1");
        pr.setDisplayName("ProteinReference1");
        pr.addComment("No value is set for the 'organism' property (must be exactly one)!");
        try {
            rule.check(pr, false);
            Assert.fail((String)"must throw BiopaxValidatorException");
        }
        catch (Exception e) {
            Model m = level3.createModel();
            m.add((BioPAXElement)taxonXref);
            m.add((BioPAXElement)bioSource);
            m.add((BioPAXElement)pr);
            this.writeExample("testProteinReferenceOrganismCRRule", m);
        }
        pr.setOrganism(bioSource);
        rule.check(pr, false);
    }

    @Test
    public void testControlTypeRule() throws IOException {
        ControlTypeRule rule = new ControlTypeRule();
        Catalysis ca = (Catalysis)level3.create(Catalysis.class, "catalysis1");
        rule.check((Object)ca, false);
        ca.setControlType(ControlType.ACTIVATION);
        rule.check((Object)ca, false);
        ca.setControlType(ControlType.INHIBITION);
        ca.addComment("error: illegal controlType");
        try {
            rule.check((Object)ca, false);
            Assert.fail((String)"must throw BiopaxValidatorException");
        }
        catch (BiopaxValidatorException e) {
            // empty catch block
        }
        TemplateReactionRegulation tr = (TemplateReactionRegulation)level3.create(TemplateReactionRegulation.class, "regulation1");
        tr.setControlType(ControlType.INHIBITION);
        rule.check((Object)tr, false);
        tr.setControlType(ControlType.ACTIVATION_ALLOSTERIC);
        tr.addComment("error: illegal controlType");
        try {
            rule.check((Object)tr, false);
            Assert.fail((String)"must throw BiopaxValidatorException");
        }
        catch (BiopaxValidatorException e) {
            // empty catch block
        }
        Model m = level3.createModel();
        ca.setControlType(ControlType.INHIBITION);
        tr.setControlType(ControlType.ACTIVATION_ALLOSTERIC);
        m.add((BioPAXElement)ca);
        m.add((BioPAXElement)tr);
        this.writeExample("testControlTypeRule.owl", m);
    }

    @Test
    public void testDegradationConversionDirectionRule() throws IOException {
        DegradationConversionDirectionRule rule = new DegradationConversionDirectionRule();
        Conversion dg = (Conversion)level3.create(Degradation.class, "degradation-conversion-1");
        rule.check((Object)dg, false);
        dg.setConversionDirection(ConversionDirectionType.REVERSIBLE);
        dg.addComment("error: illegal conversionDirection");
        try {
            rule.check((Object)dg, false);
            Assert.fail((String)"must throw BiopaxValidatorException");
        }
        catch (BiopaxValidatorException e) {
            // empty catch block
        }
        Model m = level3.createModel();
        dg.setConversionDirection(ConversionDirectionType.REVERSIBLE);
        m.add((BioPAXElement)dg);
        this.writeExample("testDegradationConversionDirectionRule.owl", m);
    }

    @Test
    public void testEntityReferenceSamePhysicalEntitiesRule() {
        Model model = BioPAXLevel.L3.getDefaultFactory().createModel();
        ProteinReference pr = (ProteinReference)model.addNew(ProteinReference.class, "pid_182");
        pr.setDisplayName("ProteinReference");
        CellularLocationVocabulary cv = (CellularLocationVocabulary)model.addNew(CellularLocationVocabulary.class, "pid_192");
        cv.addTerm("plasma membrane");
        Protein p = (Protein)model.addNew(Protein.class, "pid_181");
        p.setEntityReference((EntityReference)pr);
        p.addName("Rac1");
        p = (Protein)model.addNew(Protein.class, "pid_305");
        p.setEntityReference((EntityReference)pr);
        p.addName("Rac1");
        p.setCellularLocation(cv);
        EntityReferenceSamePhysicalEntitiesRule rule = new EntityReferenceSamePhysicalEntitiesRule();
        rule.check((Object)pr, false);
    }

    @Test
    public final void testClonedUtilityClassRule() {
        Model model = BioPAXLevel.L3.getDefaultFactory().createModel();
        Xref ref = (Xref)model.addNew(UnificationXref.class, "Xref1");
        ref.setDb("uniprotkb");
        ref.setId("P68250");
        ProteinReference pr = (ProteinReference)model.addNew(ProteinReference.class, "ProteinReference1");
        pr.setDisplayName("ProteinReference1");
        pr.addXref(ref);
        ref = (Xref)model.addNew(RelationshipXref.class, "Xref2");
        ref.setDb("refseq");
        ref.setId("NP_001734");
        ref.setIdVersion("1");
        pr.addXref(ref);
        ref = (Xref)model.addNew(UnificationXref.class, "Xref3");
        ref.setDb("uniprotkb");
        ref.setId("Q0VCL1");
        Xref uniprotX = ref;
        pr = (ProteinReference)model.addNew(ProteinReference.class, "ProteinReference2");
        pr.setDisplayName("ProteinReference2");
        pr.addXref(uniprotX);
        ref = (Xref)model.addNew(RelationshipXref.class, "Xref4");
        ref.setDb("refseq");
        ref.setId("NP_001734");
        pr.addXref(ref);
        pr = (ProteinReference)model.addNew(ProteinReference.class, "ProteinReference3");
        pr.setDisplayName("ProteinReference3");
        pr.addXref(uniprotX);
        ref = (Xref)model.addNew(RelationshipXref.class, "Xref5");
        ref.setDb("refseq");
        ref.setId("NP_001734");
        pr.addXref(ref);
        ClonedUtilityClassRule rule = new ClonedUtilityClassRule();
        Assert.assertTrue((boolean)rule.canCheck((Object)model));
        try {
            rule.check((Object)model, false);
            Assert.fail((String)"must throw BiopaxValidatorException");
        }
        catch (BiopaxValidatorException e) {
            // empty catch block
        }
        this.writeExample("testClonedUtilityClassRule.owl", model);
        rule.check((Object)model, true);
        this.writeExample("testClonedUtilityClassRuleFixed.owl", model);
    }

    @Test
    public void testDuplicateIdCaseInsensitiveRule() {
        DuplicateIdCaseInsensitiveRule rule = new DuplicateIdCaseInsensitiveRule();
        Model m = level3.createModel();
        m.addNew(UnificationXref.class, "some_id");
        m.addNew(RelationshipXref.class, "Some_ID");
        try {
            rule.check((Object)m, false);
            Assert.fail((String)"must throw BiopaxValidatorException");
        }
        catch (BiopaxValidatorException biopaxValidatorException) {
            // empty catch block
        }
    }

    @Test
    public void testConversionStoichiometryCheckRule() {
        ConversionStoichiometryCheckRule rule = new ConversionStoichiometryCheckRule();
        Model m = level3.createModel();
        Conversion c1 = (Conversion)m.addNew(Degradation.class, "degradation");
        Conversion c2 = (Conversion)m.addNew(BiochemicalReaction.class, "biochem_reaction");
        PhysicalEntity p1 = (PhysicalEntity)m.addNew(Protein.class, "protein1");
        PhysicalEntity p2 = (PhysicalEntity)m.addNew(Protein.class, "protein2");
        Complex complex = (Complex)m.addNew(Complex.class, "complex");
        Stoichiometry s1 = (Stoichiometry)m.addNew(Stoichiometry.class, "stoi1");
        Stoichiometry s2 = (Stoichiometry)m.addNew(Stoichiometry.class, "stoi2");
        s1.setPhysicalEntity(p1);
        s1.setStoichiometricCoefficient(2.0f);
        s2.setPhysicalEntity(p1);
        s2.setStoichiometricCoefficient(1.0f);
        complex.addComponent(p1);
        complex.addComponentStoichiometry(s1);
        complex.addComponent(p2);
        c1.addLeft(p1);
        c1.addLeft(p2);
        c1.addRight((PhysicalEntity)complex);
        c1.addParticipantStoichiometry(s2);
        c2.addLeft(p1);
        c2.addLeft(p2);
        c2.addRight((PhysicalEntity)complex);
        c2.addParticipantStoichiometry(s2);
        Assert.assertFalse((boolean)rule.canCheck((Object)c1));
        Assert.assertTrue((boolean)rule.canCheck((Object)c2));
        try {
            rule.check((Object)c2, false);
            Assert.fail((String)"must throw BiopaxValidatorException");
        }
        catch (BiopaxValidatorException e) {
            // empty catch block
        }
        this.writeExample("testConversionStoichiometryCheckRule.owl", m);
    }

    @Test
    public void testConversionToComplexAssemblyRule() {
        ConversionToComplexAssemblyRule rule = new ConversionToComplexAssemblyRule();
        Model m = level3.createModel();
        Conversion c1 = (Conversion)m.addNew(ComplexAssembly.class, "complex_assembly");
        Conversion c2 = (Conversion)m.addNew(BiochemicalReaction.class, "biochem_reaction");
        PhysicalEntity p1 = (PhysicalEntity)m.addNew(Protein.class, "protein1");
        PhysicalEntity p2 = (PhysicalEntity)m.addNew(Protein.class, "protein2");
        Complex complex = (Complex)m.addNew(Complex.class, "complex");
        complex.addComponent(p1);
        complex.addComponent(p2);
        c1.addLeft(p1);
        c1.addLeft(p2);
        c1.addRight((PhysicalEntity)complex);
        c2.addLeft(p1);
        c2.addLeft(p2);
        c2.addRight((PhysicalEntity)complex);
        Assert.assertFalse((boolean)rule.canCheck((Object)c1));
        Assert.assertTrue((boolean)rule.canCheck((Object)c2));
        try {
            rule.check((Object)c2, false);
            Assert.fail((String)"must throw BiopaxValidatorException");
        }
        catch (BiopaxValidatorException e) {
            // empty catch block
        }
        this.writeExample("testConversionToComplexAssemblyRule.owl", m);
    }

    @Test
    public void testPhysicalEntityAmbiguousFeatureRule() {
        PhysicalEntityAmbiguousFeatureRule rule = new PhysicalEntityAmbiguousFeatureRule();
        Model m = level3.createModel();
        Conversion c = (Conversion)m.addNew(Degradation.class, "degradation");
        PhysicalEntity p1 = (PhysicalEntity)m.addNew(Protein.class, "protein1");
        PhysicalEntity p2 = (PhysicalEntity)m.addNew(Protein.class, "protein2");
        Complex complex = (Complex)m.addNew(Complex.class, "complex");
        complex.addComponent(p1);
        complex.addComponent(p2);
        c.addLeft(p1);
        try {
            rule.check((Object)p1, false);
            Assert.fail((String)"must throw BiopaxValidatorException");
        }
        catch (BiopaxValidatorException e) {
            // empty catch block
        }
        this.writeExample("testPhysicalEntityAmbiguousFeatureRule.owl", m);
    }

    @Test
    public void testSimplePhysicalEntityFeaturesRule() {
        SimplePhysicalEntityFeaturesRule rule = new SimplePhysicalEntityFeaturesRule();
        Model m = level3.createModel();
        SimplePhysicalEntity p = (SimplePhysicalEntity)m.addNew(Protein.class, "protein1");
        EntityReference pr = (EntityReference)m.addNew(ProteinReference.class, "proteinreference1");
        EntityFeature ef = (EntityFeature)m.addNew(ModificationFeature.class, "modfeature1");
        EntityFeature ef2 = (EntityFeature)m.addNew(FragmentFeature.class, "modnotfeature1");
        p.setEntityReference(pr);
        p.addFeature(ef);
        p.addNotFeature(ef2);
        try {
            rule.check((Object)p, false);
            Assert.fail((String)"must throw BiopaxValidatorException");
        }
        catch (BiopaxValidatorException e) {
            // empty catch block
        }
        this.writeExample("testSimplePhysicalEntityFeaturesRule.owl", m);
        rule.check((Object)p, true);
        this.writeExample("testSimplePhysicalEntityFeaturesRuleFixed.owl", m);
    }

    @Test
    public void testAcyclicComplexRule() {
        AcyclicComplexRule rule = new AcyclicComplexRule();
        Model m = level3.createModel();
        Complex complex = (Complex)m.addNew(Complex.class, "complex");
        Complex component = (Complex)m.addNew(Complex.class, "component");
        complex.addComponent((PhysicalEntity)component);
        component.addComponent((PhysicalEntity)complex);
        Assert.assertTrue((boolean)rule.canCheck((Object)complex));
        try {
            rule.check((Object)complex, false);
            Assert.fail((String)"must throw BiopaxValidatorException");
        }
        catch (BiopaxValidatorException e) {
            // empty catch block
        }
        this.writeExample("testAcyclicComplexRule.owl", m);
    }

    @Test
    public void testSharedUnificationXrefRule() {
        SharedUnificationXrefRule rule = new SharedUnificationXrefRule();
        Model m = level3.createModel();
        Evidence ev1 = (Evidence)m.addNew(Evidence.class, "evidence1");
        Evidence ev2 = (Evidence)m.addNew(Evidence.class, "evidence2");
        UnificationXref x = (UnificationXref)m.addNew(UnificationXref.class, "shared");
        UnificationXref ux1 = (UnificationXref)m.addNew(UnificationXref.class, "unique1");
        UnificationXref ux2 = (UnificationXref)m.addNew(UnificationXref.class, "unique2");
        ev1.addXref((Xref)x);
        ev1.addXref((Xref)ux1);
        ev2.addXref((Xref)x);
        ev2.addXref((Xref)ux2);
        try {
            rule.check((Object)x, false);
            Assert.fail((String)"must throw BiopaxValidatorException");
        }
        catch (BiopaxValidatorException e) {
            // empty catch block
        }
        this.writeExample("testSharedUnificationXrefRule.owl", m);
    }
}

