/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BindingFeature;
import org.biopax.validator.impl.AbstractRule;
import org.biopax.validator.utils.BiopaxValidatorUtils;
import org.biopax.validator.utils.Cluster;
import org.springframework.stereotype.Component;

@Component
public class BindingFeatureExtraRules
extends AbstractRule<Model> {
    public boolean canCheck(Object thing) {
        return thing instanceof Model && ((Model)thing).getLevel() == BioPAXLevel.L3;
    }

    public void check(Model model, boolean fix) {
        HashSet bfs = new HashSet(model.getObjects(BindingFeature.class));
        Cluster<BindingFeature> groupping = new Cluster<BindingFeature>(){

            public boolean match(BindingFeature a, BindingFeature b) {
                boolean ab = a.getBindsTo() != null && b.getBindsTo() != null && a.getBindsTo().isEquivalent((BioPAXElement)b.getBindsTo());
                return !a.isEquivalent((BioPAXElement)b) && ab;
            }
        };
        Set violations = groupping.cluster(bfs, Integer.MAX_VALUE);
        for (Set s : violations) {
            if (violations.size() <= 1) continue;
            BindingFeature a = (BindingFeature)s.iterator().next();
            this.error(a, "inverse.functional.violated", false, new Object[]{"bindsTo", a.getBindsTo(), BiopaxValidatorUtils.getIdListAsString((Collection)s)});
        }
    }
}

