/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.validator.impl.AbstractRule;
import org.springframework.stereotype.Component;

@Component
public class BiopaxElementIdLengthRule
extends AbstractRule<BioPAXElement> {
    private static final int URI_MAX_LENGTH = 256;

    public boolean canCheck(Object thing) {
        return thing instanceof BioPAXElement;
    }

    public void check(BioPAXElement thing, boolean fix) {
        String rdfid = thing.getRDFId();
        if (rdfid != null && rdfid.length() > 256) {
            this.error(thing, "too.long.id", false, new Object[]{rdfid.length(), 256});
        }
    }
}

