/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Collection;
import java.util.Set;
import org.biopax.paxtools.controller.AbstractTraverser;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.UtilityClass;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.Filter;
import org.biopax.validator.impl.AbstractRule;
import org.biopax.validator.utils.BiopaxValidatorUtils;
import org.biopax.validator.utils.Cluster;
import org.springframework.stereotype.Component;

@Component
public class ClonedUtilityClassRule
extends AbstractRule<Model> {
    public void check(Model model, boolean fix) {
        Cluster<UtilityClass> algorithm = new Cluster<UtilityClass>(){

            public boolean match(UtilityClass a, UtilityClass b) {
                return !a.equals(b) && a.isEquivalent((BioPAXElement)b);
            }
        };
        Set clusters = algorithm.cluster((Collection)model.getObjects(UtilityClass.class), Integer.MAX_VALUE);
        for (Set clones : clusters) {
            if (clones.size() < 2) continue;
            UtilityClass first = (UtilityClass)clones.iterator().next();
            boolean ok = clones.remove(first);
            assert (ok);
            String idListAsString = BiopaxValidatorUtils.getIdListAsString((Collection)clones);
            if (fix) {
                this.fix(model, first, clones);
                for (UtilityClass clone : clones) {
                    model.remove((BioPAXElement)clone);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Duplicate object " + clone.getRDFId() + " " + clone.getModelInterface().getSimpleName() + " has been replaced with " + first.getRDFId() + " and removed from the model"));
                }
                this.error(first, "cloned.utility.class", true, new Object[]{idListAsString, first.getModelInterface().getSimpleName()});
                continue;
            }
            this.error(first, "cloned.utility.class", false, new Object[]{idListAsString, first.getModelInterface().getSimpleName()});
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof Model && ((Model)thing).getLevel() == BioPAXLevel.L3;
    }

    private void fix(Model model, final UtilityClass master, final Set<UtilityClass> clones) {
        if (master != null) {
            assert (clones.size() > 0);
            AbstractTraverser traverser = new AbstractTraverser((EditorMap)SimpleEditorMap.L3, new Filter[0]){

                protected void visit(Object range, BioPAXElement domain, Model model, PropertyEditor editor) {
                    if (editor instanceof ObjectPropertyEditor && clones.contains(range)) {
                        if (!master.isEquivalent((BioPAXElement)((UtilityClass)range))) {
                            ClonedUtilityClassRule.this.logger.error((Object)(master + " (" + master.getRDFId() + ", " + master.getModelInterface().getSimpleName() + ") replaces NOT semantically equivalent " + range + " (" + ((UtilityClass)range).getRDFId() + ", " + ((UtilityClass)range).getModelInterface().getSimpleName() + ")! Ignored..."));
                        }
                        if (editor.isMultipleCardinality()) {
                            editor.removeValueFromBean(range, domain);
                        }
                        editor.setValueToBean((Object)master, domain);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Replaced " + ((UtilityClass)range).getModelInterface().getSimpleName() + " " + ((UtilityClass)range).getRDFId() + " with " + master.getRDFId() + "; " + editor.toString() + "; (domain) bean: " + domain));
                        }
                    }
                }
            };
            for (BioPAXElement element : model.getObjects()) {
                traverser.traverse(element, model);
            }
            for (UtilityClass clone : clones) {
                for (String comm : clone.getComment()) {
                    master.addComment(comm);
                }
                if (master instanceof Named && clone instanceof Named) {
                    for (String n : ((Named)clone).getName()) {
                        ((Named)master).addName(n);
                    }
                }
                if (clone instanceof Xref ? !$assertionsDisabled && !((Xref)clone).getXrefOf().isEmpty() : clone instanceof EntityReference && !$assertionsDisabled && !((EntityReference)clone).getEntityReferenceOf().isEmpty()) {
                    throw new AssertionError();
                }
            }
        }
    }
}

