/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Set;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Stoichiometry;
import org.biopax.validator.impl.AbstractRule;
import org.springframework.stereotype.Component;

@Component
public class ComplexTwoOrMoreParticipantsRule
extends AbstractRule<Complex> {
    public boolean canCheck(Object thing) {
        return thing instanceof Complex;
    }

    public void check(Complex thing, boolean fix) {
        Set components = thing.getComponent();
        if (components.isEmpty()) {
            this.error(thing, "complex.incomplete", false, new Object[]{"no components"});
        } else if (components.size() == 1) {
            PhysicalEntity pe = (PhysicalEntity)components.iterator().next();
            Set stoi = thing.getComponentStoichiometry();
            String msg = "has one component";
            if (stoi.isEmpty()) {
                this.error(thing, "complex.incomplete", false, new Object[]{msg + ", but no stoichiometry defined."});
            } else {
                if (stoi.size() > 1) {
                    msg = msg + ", but multiple stoichiometries...";
                }
                boolean ok = false;
                for (Stoichiometry s : stoi) {
                    if (pe.equals(s.getPhysicalEntity()) && s.getStoichiometricCoefficient() > 1.0f) {
                        ok = true;
                        break;
                    }
                    if (pe.equals(s.getPhysicalEntity()) || s.getPhysicalEntity() == null) continue;
                    this.error(thing, "complex.stoichiometry.notcomponent", false, new Object[]{s, s.getPhysicalEntity(), pe});
                }
                if (!ok) {
                    this.error(thing, "complex.incomplete", false, new Object[]{msg + "; which stoichiometry < 2."});
                }
            }
        }
    }
}

