/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.TemplateReactionRegulation;
import org.biopax.validator.impl.AbstractRule;
import org.springframework.stereotype.Component;

@Component
public class ControlTypeRule
extends AbstractRule<Control> {
    private void fix(Control t, Object ... values) {
        if (t instanceof Catalysis) {
            ((Catalysis)t).setControlType(ControlType.ACTIVATION);
        } else if (t instanceof TemplateReactionRegulation) {
            if (values.length > 0 && values[0] instanceof ControlType) {
                ControlType ct = (ControlType)values[0];
                ((TemplateReactionRegulation)t).setControlType(ct);
            } else {
                ((TemplateReactionRegulation)t).setControlType(null);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)(t.getRDFId() + " - invalid controlType value deleted"));
                }
            }
        } else {
            this.logger.error((Object)("This does not auto-fix  controlType property of " + t.getModelInterface().getSimpleName()));
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof Control;
    }

    public void check(Control thing, boolean fix) {
        if (thing.getControlType() != null) {
            TemplateReactionRegulation trr;
            if (thing instanceof Catalysis) {
                Catalysis cat = (Catalysis)thing;
                if (cat.getControlType() != ControlType.ACTIVATION) {
                    this.error(thing, "range.violated", fix, new Object[]{"controlType", cat.getControlType().name(), "", ControlType.ACTIVATION.name() + " (or empty)"});
                    if (fix) {
                        this.fix(thing, new Object[0]);
                    }
                }
            } else if (thing instanceof TemplateReactionRegulation && (trr = (TemplateReactionRegulation)thing).getControlType() != ControlType.ACTIVATION && trr.getControlType() != ControlType.INHIBITION) {
                this.error(thing, "range.violated", fix, new Object[]{"controlType", trr.getControlType().name(), "", ControlType.ACTIVATION.name() + " or " + ControlType.INHIBITION.name() + " (or empty)"});
                if (fix) {
                    this.fix(thing, new Object[0]);
                }
            }
        }
    }
}

