/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Set;
import javax.annotation.Resource;
import org.biopax.paxtools.controller.AbstractTraverser;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Level3Element;
import org.biopax.paxtools.util.Filter;
import org.biopax.validator.impl.AbstractRule;
import org.springframework.stereotype.Component;

@Component
public class DataPropertyIllegalValueRule
extends AbstractRule<BioPAXElement> {
    @Resource
    private Set<String> warnOnDataPropertyValues;

    public void setWarnOnDataPropertyValues(Set<String> warnOnDataPropertyValues) {
        this.warnOnDataPropertyValues = warnOnDataPropertyValues;
    }

    public boolean canCheck(Object thing) {
        return thing instanceof BioPAXElement;
    }

    public void check(BioPAXElement bpe, final boolean fix) {
        SimpleEditorMap editorMap = bpe instanceof Level3Element ? SimpleEditorMap.get((BioPAXLevel)BioPAXLevel.L3) : SimpleEditorMap.get((BioPAXLevel)BioPAXLevel.L2);
        AbstractTraverser checker = new AbstractTraverser((EditorMap)editorMap, new Filter[0]){

            protected void visit(Object value, BioPAXElement parent, Model model, PropertyEditor editor) {
                if (value != null && !(value instanceof BioPAXElement) && DataPropertyIllegalValueRule.this.warnOnDataPropertyValues.contains(value.toString().trim().toUpperCase())) {
                    DataPropertyIllegalValueRule.this.error(parent, "illegal.property.value", fix, new Object[]{editor.getProperty(), value});
                    if (fix) {
                        if (editor.isMultipleCardinality()) {
                            editor.removeValueFromBean(value, parent);
                        } else {
                            editor.setValueToBean(null, parent);
                        }
                    }
                }
            }
        };
        checker.traverse(bpe, null);
    }
}

