/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Map;
import javax.annotation.Resource;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.validator.impl.AbstractRule;
import org.springframework.stereotype.Component;

@Component
public class DisplayNameRule
extends AbstractRule<Named> {
    public static final int MAX_DISPLAYNAME_LEN = 25;
    @Resource
    Map<Class<? extends BioPAXElement>, Integer> maxDisplayNameLengths;

    public boolean canCheck(Object thing) {
        return thing instanceof Named;
    }

    public void check(Named named, boolean fix) {
        String name;
        boolean fixed = false;
        if (named.getDisplayName() == null) {
            if (fix) {
                if (named.getStandardName() != null) {
                    named.setDisplayName(named.getStandardName());
                    fixed = true;
                } else if (!named.getName().isEmpty()) {
                    String dsp = (String)named.getName().iterator().next();
                    for (String name2 : named.getName()) {
                        if (name2.length() >= dsp.length()) continue;
                        dsp = name2;
                    }
                    named.setDisplayName(dsp);
                    fixed = true;
                }
            }
            this.error(named, "no.display.name", fixed && fix, new Object[0]);
        }
        if ((name = named.getDisplayName()) != null) {
            Class cl = named.getModelInterface();
            Integer max = this.maxDisplayNameLengths.containsKey(cl) ? this.maxDisplayNameLengths.get(cl) : 25;
            if (name.length() > max) {
                this.error(named, "too.long.display.name", false, new Object[]{name + (fixed ? "(auto-created form other names!)" : ""), name.length(), max});
            }
        }
    }
}

