/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Collection;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.validator.impl.AbstractRule;
import org.biopax.validator.utils.BiopaxValidatorUtils;
import org.biopax.validator.utils.Cluster;
import org.springframework.stereotype.Component;

@Component
public class DuplicateIdCaseInsensitiveRule
extends AbstractRule<Model> {
    public void check(Model model, boolean fix) {
        Cluster<BioPAXElement> algorithm = new Cluster<BioPAXElement>(){

            public boolean match(BioPAXElement a, BioPAXElement b) {
                return !a.equals(b) && a.getRDFId().equalsIgnoreCase(b.getRDFId());
            }
        };
        Set clasters = algorithm.cluster((Collection)model.getObjects(), Integer.MAX_VALUE);
        for (Set duplicates : clasters) {
            if (duplicates.size() <= 1) continue;
            BioPAXElement u = (BioPAXElement)duplicates.iterator().next();
            duplicates.remove(u);
            this.error(u, "duplicate.id.ignoringcase", false, new Object[]{BiopaxValidatorUtils.getIdListAsString((Collection)duplicates), u.getModelInterface().getSimpleName()});
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof Model;
    }
}

