/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Collection;
import java.util.Set;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.validator.impl.AbstractRule;
import org.biopax.validator.utils.BiopaxValidatorUtils;
import org.biopax.validator.utils.Cluster;
import org.springframework.stereotype.Component;

@Component
public class EntityReferenceSamePhysicalEntitiesRule
extends AbstractRule<EntityReference> {
    Cluster<SimplePhysicalEntity> algorithm = new Cluster<SimplePhysicalEntity>(){

        public boolean match(SimplePhysicalEntity e1, SimplePhysicalEntity e2) {
            assert (e1.getModelInterface().equals(e2.getModelInterface()));
            return e1.hasEquivalentFeatures((PhysicalEntity)e2) && e1.hasEquivalentCellularLocation((PhysicalEntity)e2);
        }
    };

    public void check(EntityReference eref, boolean fix) {
        Set clasters = this.algorithm.cluster((Collection)eref.getEntityReferenceOf(), Integer.MAX_VALUE);
        for (Set col : clasters) {
            if (col.size() <= 1) continue;
            SimplePhysicalEntity u = (SimplePhysicalEntity)col.iterator().next();
            col.remove(u);
            this.error(eref, "same.state.entity", false, new Object[]{u, BiopaxValidatorUtils.getIdListAsString((Collection)col)});
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof EntityReference;
    }
}

