/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import org.biopax.paxtools.controller.AbstractTraverser;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.pathway;
import org.biopax.paxtools.model.level2.pathwayStep;
import org.biopax.paxtools.model.level2.process;
import org.biopax.paxtools.util.Filter;
import org.biopax.validator.impl.AbstractRule;
import org.springframework.stereotype.Component;

@Component
public class Level2AcyclicPathwayRule
extends AbstractRule<pathway> {
    public boolean canCheck(Object thing) {
        return thing instanceof pathway;
    }

    public void check(final pathway thing, boolean fix) {
        AbstractTraverser checker = new AbstractTraverser((EditorMap)SimpleEditorMap.L2, new Filter[]{new Filter<PropertyEditor>(){

            public boolean filter(PropertyEditor editor) {
                return !"NEXT-STEP".equals(editor.getProperty());
            }
        }}){

            protected void visit(Object value, BioPAXElement parent, Model model, PropertyEditor editor) {
                if (value instanceof process || value instanceof pathwayStep) {
                    if (value instanceof pathway && thing.getRDFId().equalsIgnoreCase(((BioPAXElement)value).getRDFId())) {
                        Level2AcyclicPathwayRule.this.error(thing, "cyclic.inclusion", false, new Object[]{this.getVisited().toString()});
                        return;
                    }
                    this.traverse((BioPAXElement)value, model);
                }
            }
        };
        checker.traverse((BioPAXElement)thing, null);
    }
}

