/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.HashSet;
import org.biopax.paxtools.controller.AbstractTraverser;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.util.Filter;
import org.biopax.validator.impl.AbstractRule;
import org.biopax.validator.utils.BiopaxValidatorUtils;
import org.springframework.stereotype.Component;

@Component
public class PathwayMultiOrganismRule
extends AbstractRule<Pathway> {
    private static final Filter<PropertyEditor> filter = new Filter<PropertyEditor>(){

        public boolean filter(PropertyEditor editor) {
            return !"nextStep".equals(editor.getProperty());
        }
    };

    public void check(Pathway pathway2, boolean fix) {
        final HashSet organisms = new HashSet();
        final BioSource organism = pathway2.getOrganism();
        if (organism == null) {
            return;
        }
        AbstractTraverser runner = new AbstractTraverser((EditorMap)SimpleEditorMap.L3, new Filter[]{filter}){

            protected void visit(Object value, BioPAXElement parent, Model model, PropertyEditor editor) {
                if (value instanceof BioSource) {
                    if (!((BioPAXElement)value).isEquivalent((BioPAXElement)organism)) {
                        organisms.add((BioPAXElement)value);
                    }
                } else if (value instanceof BioPAXElement) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Traverse into " + value + " " + value.getClass().getSimpleName()));
                    }
                    this.traverse((BioPAXElement)value, model);
                }
            }
        };
        runner.traverse((BioPAXElement)pathway2, null);
        if (organisms.size() > 0) {
            this.error(pathway2, "multi.organism.pathway", false, new Object[]{organism, BiopaxValidatorUtils.toString((Object[])new Object[]{organisms})});
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof Pathway && ((Pathway)thing).getOrganism() != null;
    }
}

