/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Set;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PathwayStep;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.validator.impl.AbstractRule;
import org.springframework.stereotype.Component;

@Component
public class PathwayStepProcessesArePathwayComponents
extends AbstractRule<PathwayStep> {
    public boolean canCheck(Object thing) {
        return thing instanceof PathwayStep && ((PathwayStep)thing).getPathwayOrderOf() != null;
    }

    public void check(PathwayStep step, boolean fix) {
        Pathway pathway2 = step.getPathwayOrderOf();
        if (pathway2 != null) {
            Set pathwayComponents = pathway2.getPathwayComponent();
            for (Process stepProcess : step.getStepProcess()) {
                if (pathwayComponents.contains(stepProcess)) continue;
                this.error(step, "component.not.found", false, new Object[]{stepProcess, pathway2});
            }
        }
    }
}

