/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.validator.impl.AbstractRule;
import org.biopax.validator.utils.BiopaxValidatorUtils;
import org.biopax.validator.utils.Cluster;
import org.springframework.stereotype.Component;

@Component
public class SameNameDiffKindPhysEntitiesRule
extends AbstractRule<Model> {
    public void check(Model model, boolean fix) {
        HashSet peers = new HashSet(model.getObjects(SimplePhysicalEntity.class));
        Cluster<SimplePhysicalEntity> groupping = new Cluster<SimplePhysicalEntity>(){

            public boolean match(SimplePhysicalEntity a, SimplePhysicalEntity b) {
                return !a.equals(b) && a.getEntityReference() != null && !a.getName().isEmpty() && !b.getName().isEmpty() && !a.getEntityReference().isEquivalent((BioPAXElement)b.getEntityReference()) && !BiopaxValidatorUtils.namesInCommon((Named)a, (Named)b).isEmpty();
            }
        };
        Set sharedNamesClusters = groupping.cluster(peers, Integer.MAX_VALUE);
        for (Set sharedNames : sharedNamesClusters) {
            if (sharedNames.size() <= 1) continue;
            SimplePhysicalEntity a = (SimplePhysicalEntity)sharedNames.iterator().next();
            this.error(a, "diff.kind.same.name", false, new Object[]{BiopaxValidatorUtils.getIdListAsString((Collection)sharedNames)});
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof Model && ((Model)thing).getLevel() == BioPAXLevel.L3;
    }
}

