/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.ComplexAssembly;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Degradation;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.validator.impl.AbstractRule;
import org.springframework.stereotype.Component;

@Component
public class SimplePhysicalEntityConversionRule
extends AbstractRule<SimplePhysicalEntity> {
    public void check(SimplePhysicalEntity spe, boolean fix) {
        HashSet conversions = new HashSet(new ClassFilterSet(spe.getParticipantOf(), Conversion.class));
        for (Conversion conversion2 : conversions) {
            if (conversion2 instanceof ComplexAssembly || conversion2 instanceof Degradation) continue;
            Set side = conversion2.getLeft();
            if (side.contains(spe)) {
                side = conversion2.getRight();
            }
            if (this.sameKindEntityExists(spe, side)) continue;
            this.error(spe, "illegal.conversion", false, new Object[]{conversion2});
        }
    }

    boolean sameKindEntityExists(SimplePhysicalEntity spe, Set<PhysicalEntity> side) {
        assert (!(spe instanceof SmallMolecule));
        boolean ret = false;
        for (PhysicalEntity value : side) {
            if (value instanceof SimplePhysicalEntity) {
                SimplePhysicalEntity that = (SimplePhysicalEntity)value;
                if (!(value instanceof SmallMolecule) && that.getEntityReference() != null && that.getEntityReference().isEquivalent((BioPAXElement)spe.getEntityReference())) {
                    return true;
                }
            } else if (this.sameKindEntityExists(spe, ((Complex)value).getComponent())) {
                return true;
            }
            if (!this.sameKindEntityExists(spe, value.getMemberPhysicalEntity())) continue;
            return true;
        }
        return ret;
    }

    public boolean canCheck(Object thing) {
        return thing instanceof SimplePhysicalEntity && !(thing instanceof SmallMolecule);
    }
}

