/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.validator.impl.AbstractRule;
import org.springframework.stereotype.Component;

@Component
public class SimplePhysicalEntityFeaturesRule
extends AbstractRule<SimplePhysicalEntity> {
    public void check(SimplePhysicalEntity thing, boolean fix) {
        EntityReference er = thing.getEntityReference();
        Set erefs = er.getEntityFeature();
        HashSet peefs = new HashSet();
        peefs.addAll(thing.getFeature());
        peefs.addAll(thing.getNotFeature());
        for (EntityFeature ef : peefs) {
            if (erefs.contains(ef)) continue;
            if (fix) {
                er.addEntityFeature(ef);
            }
            this.error(thing, "improper.feature.use", fix, new Object[]{ef.getRDFId(), er.getRDFId()});
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof SimplePhysicalEntity && ((SimplePhysicalEntity)thing).getEntityReference() != null;
    }
}

