/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.validator.impl.AbstractRule;
import org.biopax.validator.utils.XrefHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UnificationXrefLimitedRule
extends AbstractRule<UnificationXref> {
    private Map<Class<BioPAXElement>, Set<String>> allow;
    private Map<Class<BioPAXElement>, Set<String>> deny;
    private XrefHelper helper;
    private Map<Class<BioPAXElement>, String> dbAllow;
    private Map<Class<BioPAXElement>, String> dbDeny;
    private boolean ready = false;

    @Resource(name="dbAllow")
    public void setDbAllow(Map<Class<BioPAXElement>, String> dbAllow) {
        this.dbAllow = new ConcurrentHashMap<Class<BioPAXElement>, String>(dbAllow);
    }

    @Resource(name="dbDeny")
    public void setDbDeny(Map<Class<BioPAXElement>, String> dbDeny) {
        this.dbDeny = new ConcurrentHashMap<Class<BioPAXElement>, String>(dbDeny);
    }

    void initInternalMaps() {
        if (!this.ready) {
            List synonymsOfDb;
            HashSet allSynonyms;
            String[] a;
            this.allow = new ConcurrentHashMap<Class<BioPAXElement>, Set<String>>();
            for (Class<BioPAXElement> clazz : this.dbAllow.keySet()) {
                a = this.dbAllow.get(clazz).toLowerCase().split(":");
                allSynonyms = new HashSet();
                for (String db : a) {
                    synonymsOfDb = this.helper.getSynonymsForDbName(db);
                    allSynonyms.addAll(synonymsOfDb);
                }
                this.allow.put(clazz, allSynonyms);
            }
            this.deny = new ConcurrentHashMap<Class<BioPAXElement>, Set<String>>();
            for (Class<BioPAXElement> clazz : this.dbDeny.keySet()) {
                a = this.dbDeny.get(clazz).toLowerCase().split(":");
                allSynonyms = new HashSet();
                for (String db : a) {
                    synonymsOfDb = this.helper.getSynonymsForDbName(db);
                    allSynonyms.addAll(synonymsOfDb);
                }
                this.deny.put(clazz, allSynonyms);
            }
            this.ready = true;
        }
    }

    @Autowired
    public UnificationXrefLimitedRule(XrefHelper xrefHelper) {
        this.helper = xrefHelper;
    }

    public boolean canCheck(Object thing) {
        return thing instanceof UnificationXref;
    }

    public void check(UnificationXref x, boolean fix) {
        if (!this.ready) {
            this.initInternalMaps();
        }
        if (x.getDb() == null || this.helper.getPrimaryDbName(x.getDb()) == null) {
            return;
        }
        String xdb = this.helper.dbName(x.getDb());
        for (XReferrable bpe : x.getXrefOf()) {
            for (Class<BioPAXElement> c : this.allow.keySet()) {
                if (!c.isInstance(bpe) || this.allow.get(c) == null || this.allow.get(c).contains(xdb)) continue;
                this.error(x, "not.allowed.xref", false, new Object[]{x.getDb(), bpe, c.getSimpleName(), this.allow.get(c).toString()});
            }
            for (Class<BioPAXElement> c : this.deny.keySet()) {
                if (!c.isInstance(bpe) || this.deny.get(c) == null || !this.deny.get(c).contains(xdb)) continue;
                this.error(x, "denied.xref", false, new Object[]{x.getDb(), bpe, c.getSimpleName(), this.deny.get(c).toString()});
            }
        }
    }
}

