/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import org.biopax.paxtools.model.level3.Xref;
import org.biopax.validator.impl.AbstractRule;
import org.biopax.validator.utils.XrefHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class XrefRule
extends AbstractRule<Xref> {
    @Autowired
    XrefHelper xrefHelper;

    public boolean canCheck(Object thing) {
        return thing instanceof Xref;
    }

    public void check(Xref x, boolean fix) {
        String db = x.getDb();
        if (db != null) {
            String preferedDbName = this.xrefHelper.getPrimaryDbName(db);
            if (preferedDbName == null) {
                this.error(x, "unknown.db", false, new Object[]{db});
                return;
            }
            String id = x.getId();
            if (id != null) {
                if (!this.xrefHelper.canCheckIdFormatIn(preferedDbName)) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)("Can't check IDs (no regexp) for " + db + " (" + preferedDbName + ")"));
                    }
                } else if (!this.xrefHelper.checkIdFormat(preferedDbName, id)) {
                    String regxp = this.xrefHelper.getRegexpString(preferedDbName);
                    this.error(x, "invalid.id.format", false, new Object[]{db, preferedDbName, id, regxp});
                    if (fix) {
                        String newId;
                        int i = id.lastIndexOf(45);
                        if (i < 0) {
                            i = id.lastIndexOf(95);
                        }
                        if (i < 0) {
                            i = id.lastIndexOf(46);
                        }
                        if (i > 0 && i < id.length() && this.xrefHelper.checkIdFormat(preferedDbName, newId = id.substring(0, i))) {
                            x.setId(newId);
                            x.setIdVersion(id.substring(i + 1));
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("auto-fix: split id and idVersion for xref: " + x + " " + x.getRDFId()));
                            }
                            this.error(x, "invalid.id.format", true, new Object[0]);
                        }
                        if ((i = regxp.lastIndexOf(58)) > 0) {
                            String newId2;
                            String prefix = regxp.substring(1, i).toUpperCase();
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Trying to fix id with missing prefix: " + prefix));
                            }
                            if (preferedDbName.equalsIgnoreCase(this.xrefHelper.getPrimaryDbName(prefix)) && !id.toUpperCase().startsWith(prefix) && this.xrefHelper.checkIdFormat(preferedDbName, newId2 = prefix + ':' + id)) {
                                x.setId(newId2);
                                this.error(x, "invalid.id.format", true, new Object[0]);
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug((Object)(x.getModelInterface().getSimpleName() + " " + x + " 'id' auto-fixed! (was: " + id + ")"));
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

