/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.HashSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.validator.jaxb.Behavior;
import org.biopax.validator.jaxb.ValidatorResponse;

public class BiopaxValidatorClient {
    private static final Log log = LogFactory.getLog(BiopaxValidatorClient.class);
    public static final String DEFAULT_VALIDATOR_URL = "http://www.biopax.org/biopax-validator/check.html";
    private static HttpClient httpClient = new HttpClient();
    private String url;

    public BiopaxValidatorClient(String url) {
        this.url = url != null ? url : DEFAULT_VALIDATOR_URL;
    }

    public BiopaxValidatorClient() {
        this(DEFAULT_VALIDATOR_URL);
    }

    public void validate(boolean autofix, boolean normalize, RetFormat retFormat, Behavior filterBy, Integer maxErrs, String biopaxUrl, File[] biopaxFiles, OutputStream out) throws IOException {
        String line;
        HashSet<Object> parts = new HashSet<Object>();
        if (autofix) {
            parts.add(new StringPart("autofix", "true"));
        }
        if (normalize) {
            parts.add(new StringPart("normalize", "true"));
        }
        if (retFormat != null) {
            parts.add(new StringPart("retDesired", retFormat.toString().toLowerCase()));
        }
        if (filterBy != null) {
            parts.add(new StringPart("filter", filterBy.toString()));
        }
        if (maxErrs != null && maxErrs > 0) {
            parts.add(new StringPart("maxErrors", maxErrs.toString()));
        }
        if (biopaxFiles != null && biopaxFiles.length > 0) {
            for (File f : biopaxFiles) {
                parts.add(new FilePart(f.getName(), f));
            }
        } else if (biopaxUrl != null) {
            parts.add(new StringPart("url", biopaxUrl));
        } else {
            log.error((Object)"Nothing to do (no BioPAX data specified)!");
            return;
        }
        PostMethod post = new PostMethod(this.url);
        post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts.toArray(new Part[0]), post.getParams()));
        int status = httpClient.executeMethod((HttpMethod)post);
        if (log.isInfoEnabled()) {
            log.info((Object)("HTTP Status Text>>>" + HttpStatus.getStatusText((int)status)));
        }
        BufferedReader res = new BufferedReader(new InputStreamReader(post.getResponseBodyAsStream()));
        PrintWriter writer = new PrintWriter(out);
        while ((line = res.readLine()) != null) {
            writer.println(line);
        }
        writer.flush();
        res.close();
        post.releaseConnection();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public static ValidatorResponse unmarshal(String xml) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.biopax.validator.jaxb");
        Unmarshaller un = jaxbContext.createUnmarshaller();
        StreamSource src = new StreamSource(new StringReader(xml));
        ValidatorResponse resp = (ValidatorResponse)un.unmarshal((Source)src, ValidatorResponse.class).getValue();
        return resp;
    }

    public static enum RetFormat {
        HTML,
        XML,
        OWL;

    }
}

