/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.tomcat;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.catalina.loader.ResourceEntry;
import org.apache.catalina.loader.WebappClassLoader;
import org.springframework.instrument.classloading.WeavingTransformer;

public class TomcatInstrumentableClassLoader
extends WebappClassLoader {
    private static final String CLASS_SUFFIX = ".class";
    private final WeavingTransformer weavingTransformer = new WeavingTransformer(this);

    public TomcatInstrumentableClassLoader() {
    }

    public TomcatInstrumentableClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.weavingTransformer.addTransformer(transformer);
    }

    public ClassLoader getThrowawayClassLoader() {
        WebappClassLoader tempLoader = new WebappClassLoader();
        TomcatInstrumentableClassLoader.shallowCopyFieldState(this, tempLoader);
        return tempLoader;
    }

    protected ResourceEntry findResourceInternal(String name, String path) {
        ResourceEntry entry = super.findResourceInternal(name, path);
        if (entry != null && entry.binaryContent != null && path.endsWith(CLASS_SUFFIX)) {
            String className = name.endsWith(CLASS_SUFFIX) ? name.substring(0, name.length() - CLASS_SUFFIX.length()) : name;
            byte[] transformed = this.weavingTransformer.transformIfNecessary(className, entry.binaryContent);
            entry.binaryContent = transformed;
        }
        return entry;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("\r\n");
        sb.append(super.toString());
        return sb.toString();
    }

    private static void shallowCopyFieldState(Object src, Object dest) throws IllegalArgumentException {
        if (src == null) {
            throw new IllegalArgumentException("Source for field copy cannot be null");
        }
        if (dest == null) {
            throw new IllegalArgumentException("Destination for field copy cannot be null");
        }
        Class targetClass = TomcatInstrumentableClassLoader.findCommonAncestor(src.getClass(), dest.getClass());
        do {
            Field[] fields = targetClass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || field.getName().equals("resourceEntries")) continue;
                try {
                    field.setAccessible(true);
                    Object srcValue = field.get(src);
                    field.set(dest, srcValue);
                    continue;
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access field '" + fields[i].getName() + "': " + ex);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    private static Class findCommonAncestor(Class one, Class two) throws IllegalArgumentException {
        Class ancestor;
        for (ancestor = one; ancestor != Object.class || ancestor != null; ancestor = ancestor.getSuperclass()) {
            if (!ancestor.isAssignableFrom(two)) continue;
            return ancestor;
        }
        for (ancestor = two; ancestor != Object.class || ancestor != null; ancestor = ancestor.getSuperclass()) {
            if (!ancestor.isAssignableFrom(one)) continue;
            return ancestor;
        }
        return null;
    }
}

