/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.CellVocabulary;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.EvidenceCodeVocabulary;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.validator.Validator;
import org.biopax.validator.result.Behavior;
import org.biopax.validator.result.ErrorType;
import org.biopax.validator.result.Validation;
import org.biopax.validator.rules.XrefRule;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:validator-aop-context.xml"})
public class AOPAspectJLTWIntegrationTest {
    @Autowired
    Validator validator;
    @Autowired
    ApplicationContext context;
    BioPAXFactory factory3 = BioPAXLevel.L3.getDefaultFactory();

    @Test
    public void testValidator() throws IOException {
        Resource resource = this.context.getResource("classpath:biopax3-short-metabolic-pathway.owl");
        Validation result = new Validation();
        result.setDescription(resource.getDescription());
        this.validator.importModel(result, resource.getInputStream());
        this.validator.validate(result);
        System.out.println(result.getError().toString());
        Assert.assertFalse((boolean)result.getError().isEmpty());
        this.validator.getResults().clear();
    }

    @Test
    public void testRange1() {
        Evidence ev = (Evidence)this.factory3.create(Evidence.class, "1");
        EvidenceCodeVocabulary ec = (EvidenceCodeVocabulary)this.factory3.create(EvidenceCodeVocabulary.class, "2");
        ev.addEvidenceCode(ec);
        CellVocabulary cv = (CellVocabulary)this.factory3.create(CellVocabulary.class, "3");
        HashSet<Object> set = new HashSet<Object>();
        set.add(ec);
        set.add(cv);
    }

    @Test
    public void testXrefRuleAOP() {
        XrefRule rule = (XrefRule)this.context.getBean("xrefRule");
        rule.setPostModelOnly(false);
        UnificationXref x = (UnificationXref)this.factory3.create(UnificationXref.class, "Illegal-Xref-Db");
        Model model = this.factory3.createModel();
        Validation validation = new Validation("test");
        this.validator.associate((Object)model, validation);
        this.validator.indirectlyAssociate((Object)model, (Object)x);
        model.add((BioPAXElement)x);
        x.setDb("ILLEGALDB");
        x.setDb("ENTREZGENE");
        rule.setPostModelOnly(true);
        this.validator.getResults().remove(validation);
        Collection errors = validation.getError();
        Assert.assertFalse((boolean)errors.isEmpty());
        Assert.assertNotNull((Object)validation.findErrorType("unknown.db", Behavior.ERROR));
        Assert.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testDuplicateNamesImport() throws IOException {
        Validation validation = new Validation();
        validation.setFix(true);
        this.validator.importModel(validation, this.getClass().getResourceAsStream("testDuplicateNamesImport.xml"));
        ErrorType error = validation.findErrorType("duplicate.names", Behavior.WARNING);
        Assert.assertNotNull((Object)error);
    }

    @Test
    public void testSyntaxErrors() throws IOException {
        Validation validation = new Validation();
        this.validator.importModel(validation, this.getClass().getResourceAsStream("testSyntaxErrors.xml"));
        ErrorType error = validation.findErrorType("unknown.property", Behavior.ERROR);
        Assert.assertNotNull((Object)error);
    }

    @Test
    public void testClonedUtilityClass() throws IOException {
        Validation validation = new Validation();
        this.validator.importModel(validation, this.getClass().getResourceAsStream("testEvidenceEquivalence.xml"));
        this.validator.validate(validation);
        ErrorType error = validation.findErrorType("cloned.utility.class", Behavior.WARNING);
        Assert.assertNull((Object)error);
    }

    @Test
    public void testMemberPhysicalEntityRange() throws IOException {
        Validation validation = new Validation();
        this.validator.importModel(validation, this.getClass().getResourceAsStream("testMemberPhysicalEntityRange.xml"));
        this.validator.validate(validation);
        ErrorType error = validation.findErrorType("syntax.error", Behavior.ERROR);
        Assert.assertNotNull((Object)error);
    }
}

