/*
 * Decompiled with CFR 0.152.
 */
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import psidev.ontology_manager.Ontology;
import psidev.ontology_manager.OntologyManager;
import psidev.ontology_manager.OntologyTermI;
import psidev.ontology_manager.impl.OntologyLoaderException;
import psidev.ontology_manager.impl.OntologyManagerContext;
import psidev.ontology_manager.impl.OntologyManagerImpl;
import psidev.ontology_manager.impl.OntologyTermImpl;
import psidev.ontology_manager.impl.OntologyUtils;

public class LocalOntologyTest {
    static OntologyManager manager;
    static Ontology mod;
    static Ontology mi;
    static Ontology so;

    @Test
    public void getValidTerms() throws OntologyLoaderException {
        Set terms = mod.getValidTerms("MOD:00647", true, false);
        Assert.assertEquals((long)3L, (long)terms.size());
    }

    @Test
    public void getMiTermSynonyms() throws OntologyLoaderException {
        Set terms = mi.getValidTerms("MI:0018", false, true);
        Assert.assertEquals((long)1L, (long)terms.size());
        OntologyTermI y2h = (OntologyTermI)terms.iterator().next();
        Assert.assertEquals((long)8L, (long)y2h.getNameSynonyms().size());
        Assert.assertTrue((boolean)y2h.getNameSynonyms().contains("2h"));
        Assert.assertTrue((boolean)y2h.getNameSynonyms().contains("classical two hybrid"));
        Assert.assertTrue((boolean)y2h.getNameSynonyms().contains("Gal4 transcription regeneration"));
        Assert.assertTrue((boolean)y2h.getNameSynonyms().contains("2 hybrid"));
        Assert.assertTrue((boolean)y2h.getNameSynonyms().contains("two-hybrid"));
        Assert.assertTrue((boolean)y2h.getNameSynonyms().contains("2H"));
        Assert.assertTrue((boolean)y2h.getNameSynonyms().contains("yeast two hybrid"));
        Assert.assertTrue((boolean)y2h.getNameSynonyms().contains("2-hybrid"));
    }

    @Test
    public void getMiTermSynonyms0217() throws OntologyLoaderException {
        Set terms = mi.getValidTerms("MI:0217", false, true);
        Assert.assertEquals((long)1L, (long)terms.size());
        OntologyTermI phosphorylation = mi.getTermForAccession("MI:0217");
        Assert.assertEquals((long)1L, (long)phosphorylation.getNameSynonyms().size());
        Collection names = OntologyUtils.getTermNames((Collection)terms);
        Assert.assertTrue((boolean)names.contains("phosphorylation"));
        Assert.assertTrue((boolean)names.contains("phosphorylation reaction"));
    }

    @Test
    public void getModTermSynonyms() throws OntologyLoaderException {
        Set terms = mod.getValidTerms("MOD:00007", false, true);
        Assert.assertEquals((long)1L, (long)terms.size());
        OntologyTermI term = (OntologyTermI)terms.iterator().next();
        Assert.assertEquals((long)3L, (long)term.getNameSynonyms().size());
        Assert.assertTrue((boolean)term.getNameSynonyms().contains("Delta:S(-1)Se(1)"));
        Assert.assertTrue((boolean)term.getNameSynonyms().contains("Se(S)Res"));
        Assert.assertTrue((boolean)term.getNameSynonyms().contains("Selenium replaces sulphur"));
    }

    @Test
    public void isObsolete() throws Exception {
        OntologyTermI term = mi.getTermForAccession("MI:0205");
        Assert.assertTrue((boolean)mi.isObsolete(term));
        OntologyTermI term2 = mi.getTermForAccession("MI:0001");
        Assert.assertFalse((boolean)mi.isObsolete(term2));
    }

    @Test
    public void isObsolete_unknown_accession() throws Exception {
        OntologyTermImpl term = new OntologyTermImpl("MI", "MI:xxxx", "bogus term");
        Assert.assertFalse((boolean)mi.isObsolete((OntologyTermI)term));
    }

    @Test
    public void getTermForAccession() throws Exception {
        OntologyTermI term = mi.getTermForAccession("MI:0013");
        Assert.assertNotNull((Object)term);
        Assert.assertEquals((Object)"MI:0013", (Object)term.getTermAccession());
        Assert.assertEquals((Object)"biophysical", (Object)term.getPreferredName());
    }

    @Test
    public void getTermForAccession_unknown_accession() throws Exception {
        OntologyTermI term = mi.getTermForAccession("MI:xxxx");
        Assert.assertNull((Object)term);
    }

    @Test
    public void getDirectChildren() throws Exception {
        OntologyTermI term = mi.getTermForAccession("MI:0417");
        Assert.assertNotNull((Object)term);
        Set children = mi.getDirectChildren(term);
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertTrue((boolean)children.contains(new OntologyTermImpl("MI", "MI:0602", "chemical footprinting")));
        Assert.assertTrue((boolean)children.contains(new OntologyTermImpl("MI", "MI:0605", "enzymatic footprinting")));
    }

    @Test
    public void getDirectChildren_unknown_accession() throws Exception {
        OntologyTermImpl term = new OntologyTermImpl("MI", "MI:xxxx", "bogus term");
        Set children = mi.getDirectChildren((OntologyTermI)term);
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((long)0L, (long)children.size());
    }

    @Test
    public void getAllChildren() throws Exception {
        OntologyTermI term = mi.getTermForAccession("MI:0417");
        Assert.assertNotNull((Object)term);
        Set children = mi.getAllChildren(term);
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((String)children.toString(), (long)7L, (long)children.size());
        Assert.assertTrue((boolean)children.contains(new OntologyTermImpl("MI", "MI:0602", "chemical footprinting")));
        Assert.assertTrue((boolean)children.contains(new OntologyTermImpl("MI", "MI:0605", "enzymatic footprinting")));
        Assert.assertTrue((boolean)children.contains(new OntologyTermImpl("MI", "MI:0603", "dimethylsulphate footprinting")));
        Assert.assertTrue((boolean)children.contains(new OntologyTermImpl("MI", "MI:0604", "potassium permanganate footprinting")));
        Assert.assertTrue((boolean)children.contains(new OntologyTermImpl("MI", "MI:0606", "DNase I footprinting")));
        Assert.assertTrue((boolean)children.contains(new OntologyTermImpl("MI", "MI:0814", "protease accessibility laddering")));
        Assert.assertTrue((boolean)children.contains(new OntologyTermImpl("MI", "MI:0901", "isotope label footprinting")));
    }

    @Test
    public void getAllChildren_unknown_accession() throws Exception {
        OntologyTermImpl term = new OntologyTermImpl("MI", "MI:xxxx", "bogus term");
        Set children = mi.getAllChildren((OntologyTermI)term);
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((long)0L, (long)children.size());
    }

    @Test
    public void getDirectParents() throws Exception {
        OntologyTermI term = mi.getTermForAccession("MI:0013");
        Assert.assertNotNull((Object)term);
        Set parents = mi.getDirectParents(term);
        Assert.assertNotNull((Object)parents);
        Assert.assertEquals((long)1L, (long)parents.size());
        Assert.assertTrue((boolean)parents.contains(new OntologyTermImpl("MI", "MI:0045", "experimental interaction detection")));
    }

    @Test
    public void getDirectParents_unknown_accession() throws Exception {
        OntologyTermImpl term = new OntologyTermImpl("MI", "MI:xxxx", "bogus term");
        Set parents = mi.getDirectParents((OntologyTermI)term);
        Assert.assertNotNull((Object)parents);
        Assert.assertEquals((long)0L, (long)parents.size());
    }

    @Test
    public void getAllParents() throws Exception {
        OntologyTermI term = mi.getTermForAccession("MI:0013");
        Assert.assertNotNull((Object)term);
        Set parents = mi.getAllParents(term);
        Assert.assertNotNull((Object)parents);
        Assert.assertEquals((long)3L, (long)parents.size());
        Assert.assertTrue((boolean)parents.contains(new OntologyTermImpl("MI", "MI:0045", "experimental interaction detection")));
        Assert.assertTrue((boolean)parents.contains(new OntologyTermImpl("MI", "MI:0001", "interaction detection method")));
        Assert.assertTrue((boolean)parents.contains(new OntologyTermImpl("MI", "MI:0000", "molecular interaction")));
    }

    @Test
    public void getAllParents_unknown_accession() throws Exception {
        OntologyTermImpl term = new OntologyTermImpl("MI", "MI:xxxx", "bogus term");
        Set parents = mi.getAllParents((OntologyTermI)term);
        Assert.assertNotNull((Object)parents);
        Assert.assertEquals((long)0L, (long)parents.size());
    }

    private void printTerms(Collection<OntologyTermI> terms) {
        for (OntologyTermI term : terms) {
            System.out.println(term);
        }
    }

    @Test
    public void getValidTerms_so_small() throws OntologyLoaderException {
        OntologyTermI parent = so.getTermForAccession("SO:0000805");
        Set terms = so.getAllChildren(parent);
        Assert.assertEquals((long)4L, (long)terms.size());
    }

    @Test
    public void getValidTerms_so_large() throws OntologyLoaderException {
        OntologyTermI parent = so.getTermForAccession("SO:0000001");
        Set terms = so.getAllChildren(parent);
        Assert.assertTrue((terms.size() > 10 ? 1 : 0) != 0);
    }

    @Test
    public final void testSearchTermByName() {
        Set term = manager.searchTermByName("O-phospho-L-serine");
        Assert.assertFalse((boolean)term.isEmpty());
    }

    @Test
    public final void testTermByAccession() {
        OntologyTermI term = mod.getTermForAccession("MOD:00046");
        Assert.assertNotNull((Object)term);
        Assert.assertEquals((Object)"MOD", (Object)term.getOntologyId());
        term = manager.findTermByAccession("MOD:00046");
        Assert.assertNotNull((Object)term);
        Assert.assertEquals((Object)"MOD", (Object)term.getOntologyId());
    }

    @Test
    public void getModChildren01157() throws OntologyLoaderException {
        Set terms = mod.getValidTerms("MOD:01157", true, false);
        Assert.assertFalse((boolean)terms.isEmpty());
        Assert.assertTrue((boolean)OntologyUtils.getAccessions((Collection)terms).contains("MOD:00036"));
        Assert.assertTrue((boolean)OntologyUtils.getTermNames((Collection)terms).contains("(2S,3R)-3-hydroxyaspartic acid"));
    }

    static {
        OntologyManagerContext.getInstance().setStoreOntologiesLocally(true);
        Properties cfg = new Properties();
        cfg.put("SO", "http://song.cvs.sourceforge.net/viewvc/song/ontology/so.obo?revision=1.310");
        cfg.put("MI", "http://psidev.cvs.sourceforge.net/viewvc/psidev/psi/mi/rel25/data/psi-mi25.obo?revision=1.58");
        cfg.put("MOD", "http://psidev.cvs.sourceforge.net/viewvc/psidev/psi/mod/data/PSI-MOD.obo?revision=1.23");
        try {
            manager = new OntologyManagerImpl(cfg);
            mod = manager.getOntology("MOD");
            mi = manager.getOntology("MI");
            so = manager.getOntology("SO");
        }
        catch (OntologyLoaderException e) {
            throw new RuntimeException(e);
        }
    }
}

