/*
 * Decompiled with CFR 0.152.
 */
import java.util.Properties;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import psidev.ontology_manager.Ontology;
import psidev.ontology_manager.impl.OntologyImpl;
import psidev.ontology_manager.impl.OntologyLoaderException;
import psidev.ontology_manager.impl.OntologyManagerContext;
import psidev.ontology_manager.impl.OntologyManagerImpl;

public class OntologyParserTest {
    @Test
    public void ontologyLoading() throws OntologyLoaderException {
        OntologyManagerContext.getInstance().setStoreOntologiesLocally(true);
        Properties cfg = new Properties();
        cfg.put("SO", "http://song.cvs.sourceforge.net/viewvc/song/ontology/so.obo?revision=1.310");
        cfg.put("MI", "http://psidev.cvs.sourceforge.net/viewvc/*checkout*/psidev/psi/mi/rel25/data/psi-mi25.obo?revision=1.60");
        cfg.put("MOD", "http://psidev.cvs.sourceforge.net/viewvc/*checkout*/psidev/psi/mod/data/PSI-MOD.obo?revision=1.24");
        OntologyManagerImpl manager = new OntologyManagerImpl(cfg);
        Set ontologyIDs = manager.getOntologyIDs();
        Assert.assertTrue((boolean)ontologyIDs.contains("MOD"));
        Assert.assertTrue((boolean)ontologyIDs.contains("SO"));
        Assert.assertTrue((boolean)ontologyIDs.contains("MI"));
        Ontology oa2 = manager.getOntology("MOD");
        Assert.assertNotNull((Object)oa2);
        Assert.assertTrue((boolean)(oa2 instanceof OntologyImpl));
        oa2 = manager.getOntology("SO");
        Assert.assertNotNull((Object)oa2);
        Assert.assertTrue((boolean)(oa2 instanceof OntologyImpl));
        oa2 = manager.getOntology("MI");
        Assert.assertNotNull((Object)oa2);
        Assert.assertTrue((boolean)(oa2 instanceof OntologyImpl));
    }
}

