/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.server;

import java.util.Map;
import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperException;
import org.bridgedb.IDMapperStack;
import org.bridgedb.Xref;
import org.bridgedb.server.IDMapperResource;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.ResourceException;

public class Attributes
extends IDMapperResource {
    Xref xref;
    String attrType;

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        try {
            String id = this.urlDecode((String)this.getRequest().getAttributes().get("id"));
            String dsName = this.urlDecode((String)this.getRequest().getAttributes().get("system"));
            DataSource dataSource = this.parseDataSource(dsName);
            if (dataSource == null) {
                throw new IllegalArgumentException("Unknown datasource: " + dsName);
            }
            this.xref = new Xref(id, dataSource);
            this.attrType = (String)this.getRequest().getAttributes().get("attrName");
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    @Get
    public String getAttributes() {
        try {
            if (this.attrType != null) {
                return this.getAttributesWithType();
            }
            return this.getAttributesWithoutType();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatus(Status.SERVER_ERROR_INTERNAL);
            return e.getMessage();
        }
    }

    private String getAttributesWithType() throws IDMapperException {
        IDMapperStack mapper = this.getIDMappers();
        Set values = mapper.getAttributes(this.xref, this.attrType);
        StringBuilder str = new StringBuilder();
        for (String v : values) {
            str.append(v);
            str.append("\n");
        }
        return str.toString();
    }

    private String getAttributesWithoutType() throws IDMapperException {
        IDMapperStack mapper = this.getIDMappers();
        Map values = mapper.getAttributes(this.xref);
        StringBuilder str = new StringBuilder();
        for (String attr : values.keySet()) {
            for (String v : (Set)values.get(attr)) {
                str.append(attr);
                str.append("\t");
                str.append(v);
                str.append("\n");
            }
        }
        return str.toString();
    }
}

