/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.server;

import java.io.File;
import java.io.IOException;
import org.bridgedb.IDMapperException;
import org.bridgedb.bio.BioDataSource;
import org.bridgedb.rdb.GdbProvider;
import org.bridgedb.server.AttributeSearch;
import org.bridgedb.server.AttributeSet;
import org.bridgedb.server.Attributes;
import org.bridgedb.server.BackPageText;
import org.bridgedb.server.Config;
import org.bridgedb.server.Contents;
import org.bridgedb.server.FreeSearch;
import org.bridgedb.server.IsFreeSearchSupported;
import org.bridgedb.server.IsMappingSupported;
import org.bridgedb.server.NoMatch;
import org.bridgedb.server.Properties;
import org.bridgedb.server.SupportedSourceDataSources;
import org.bridgedb.server.SupportedTargetDataSources;
import org.bridgedb.server.XrefExists;
import org.bridgedb.server.Xrefs;
import org.restlet.Application;
import org.restlet.Restlet;
import org.restlet.routing.Redirector;
import org.restlet.routing.Route;
import org.restlet.routing.Router;

public class IDMapperService
extends Application {
    public static final String CONF_GDBS = "gdb.config";
    public static final String PAR_ORGANISM = "organism";
    public static final String PAR_ID = "id";
    public static final String PAR_SYSTEM = "system";
    public static final String PAR_QUERY = "query";
    public static final String PAR_TARGET_SYSTEM = "dataSource";
    public static final String PAR_TARGET_ATTR_NAME = "attrName";
    public static final String PAR_TARGET_LIMIT = "limit";
    public static final String PAR_SOURCE_SYSTEM = "src";
    public static final String PAR_DEST_SYSTEM = "dest";
    public final File configFile;
    private boolean transitive;
    public static final String URL_HOME = "/";
    public static final String URL_NO_MATCH = "/{organism}";
    public static final String URL_XREFS = "/{organism}/xrefs/{system}/{id}";
    public static final String URL_SEARCH = "/{organism}/search/{query}";
    public static final String URL_XREF_EXISTS = "/{organism}/xrefExists/{system}/{id}";
    public static final String URL_PROPERTIES = "/{organism}/properties";
    public static final String URL_SUPPORTED_SOURCE_DATASOURCES = "/{organism}/sourceDataSources";
    public static final String URL_SUPPORTED_TARGET_DATASOURCES = "/{organism}/targetDataSources";
    public static final String URL_IS_FREE_SEARCH_SUPPORTED = "/{organism}/isFreeSearchSupported";
    public static final String URL_IS_MAPPING_SUPPORTED = "/{organism}/isMappingSupported/{src}/{dest}";
    public static final String URL_ATTRIBUTE_SEARCH = "/{organism}/attributeSearch/{query}";
    public static final String URL_ATTRIBUTES = "/{organism}/attributes/{system}/{id}";
    public static final String URL_ATTRIBUTE_SET = "/{organism}/attributeSet";
    public static final String URL_CONFIG = "/config";
    public static final String URL_CONTENTS = "/contents";
    public static final String URL_BACK_PAGE_TEXT = "/{organism}/backPageText/{system}/{id}";
    private GdbProvider gdbProvider;

    public IDMapperService(File aConfigFile, boolean transitive) {
        this.transitive = transitive;
        this.configFile = aConfigFile == null ? new File(CONF_GDBS) : aConfigFile;
        if (!this.configFile.exists()) {
            System.err.println("Could not find config file " + this.configFile);
            System.err.println("Please copy org.bridgedb.server/gdb.config.template and adjust it to your needs");
            System.exit(1);
        }
    }

    public synchronized void start() throws Exception {
        super.start();
        BioDataSource.init();
        this.connectGdbs();
    }

    public Restlet createRoot() {
        Router router = new Router(this.getContext());
        String target = "http://bridgedb.org/wiki/BridgeWebservice";
        Redirector redirector = new Redirector(this.getContext(), target, 4);
        router.attach(URL_HOME, (Restlet)redirector);
        router.attach(URL_CONFIG, Config.class);
        router.attach(URL_CONTENTS, Contents.class);
        Route xrefsRoute = router.attach(URL_XREFS, Xrefs.class);
        xrefsRoute.extractQuery(PAR_TARGET_SYSTEM, PAR_TARGET_SYSTEM, true);
        Route searchRoute = router.attach(URL_SEARCH, FreeSearch.class);
        searchRoute.extractQuery(PAR_TARGET_LIMIT, PAR_TARGET_LIMIT, true);
        router.attach(URL_XREF_EXISTS, XrefExists.class);
        router.attach(URL_PROPERTIES, Properties.class);
        router.attach(URL_SUPPORTED_SOURCE_DATASOURCES, SupportedSourceDataSources.class);
        router.attach(URL_SUPPORTED_TARGET_DATASOURCES, SupportedTargetDataSources.class);
        router.attach(URL_ATTRIBUTE_SET, AttributeSet.class);
        router.attach(URL_IS_FREE_SEARCH_SUPPORTED, IsFreeSearchSupported.class);
        router.attach(URL_IS_MAPPING_SUPPORTED, IsMappingSupported.class);
        Route attrSearchRoute = router.attach(URL_ATTRIBUTE_SEARCH, AttributeSearch.class);
        attrSearchRoute.extractQuery(PAR_TARGET_LIMIT, PAR_TARGET_LIMIT, true);
        attrSearchRoute.extractQuery(PAR_TARGET_ATTR_NAME, PAR_TARGET_ATTR_NAME, true);
        Route attributesRoute = router.attach(URL_ATTRIBUTES, Attributes.class);
        attributesRoute.extractQuery(PAR_TARGET_ATTR_NAME, PAR_TARGET_ATTR_NAME, true);
        router.attach(URL_BACK_PAGE_TEXT, BackPageText.class);
        router.attach(URL_NO_MATCH, NoMatch.class);
        return router;
    }

    public GdbProvider getGdbProvider() {
        return this.gdbProvider;
    }

    private void connectGdbs() throws IDMapperException, IOException, ClassNotFoundException {
        String[] gdbconf = this.getContext().getParameters().getValuesArray(CONF_GDBS);
        File gdbFile = this.configFile;
        if (gdbconf.length > 0) {
            gdbFile = new File(gdbconf[0]);
        }
        this.gdbProvider = GdbProvider.fromConfigFile((File)gdbFile, (boolean)this.transitive);
    }
}

