/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.server;

import org.bridgedb.DataSource;
import org.bridgedb.IDMapperStack;
import org.bridgedb.Xref;
import org.bridgedb.server.IDMapperResource;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.ResourceException;

public class XrefExists
extends IDMapperResource {
    Xref xref;

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        try {
            String id = this.urlDecode((String)this.getRequest().getAttributes().get("id"));
            String dsName = this.urlDecode((String)this.getRequest().getAttributes().get("system"));
            DataSource dataSource = this.parseDataSource(dsName);
            if (dataSource == null) {
                throw new IllegalArgumentException("Unknown datasource: " + dsName);
            }
            this.xref = new Xref(id, dataSource);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    @Get
    public String isFreeSearchSupported() {
        try {
            IDMapperStack mapper = this.getIDMappers();
            return "" + mapper.xrefExists(this.xref);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatus(Status.SERVER_ERROR_INTERNAL);
            return e.getMessage();
        }
    }
}

