/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.webservice.synergizer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bridgedb.AbstractIDMapperCapabilities;
import org.bridgedb.BridgeDb;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperCapabilities;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.impl.InternalUtils;
import org.bridgedb.webservice.IDMapperWebservice;
import org.bridgedb.webservice.synergizer.SynergizerStub;

public class IDMapperSynergizer
extends IDMapperWebservice {
    private SynergizerStub stub;
    private String baseUrl;
    private String authority;
    private String species;
    private Set<DataSource> supportedSrcDs;
    private Set<DataSource> supportedTgtDs;
    private Map<DataSource, Set<DataSource>> mapSrcDsTgtDs;
    private boolean closed = false;
    private SynergizerCapabilities caps = new SynergizerCapabilities();

    public IDMapperSynergizer(String authority, String species) throws IDMapperException {
        this(authority, species, "http://llama.mshri.on.ca/cgi/synergizer/serv");
    }

    public IDMapperSynergizer(String authority, String species, String baseUrl) throws IDMapperException {
        this.baseUrl = baseUrl;
        this.authority = authority;
        this.species = species;
        this.init();
    }

    public void init() throws IDMapperException {
        try {
            this.stub = SynergizerStub.getInstance(this.baseUrl);
        }
        catch (IOException e) {
            throw new IDMapperException((Throwable)e);
        }
        this.supportedSrcDs = this.getSupportedSrcDataSources();
        this.mapSrcDsTgtDs = this.getMapSrcTgt();
        this.supportedTgtDs = new HashSet<DataSource>();
        for (Set<DataSource> dss : this.mapSrcDsTgtDs.values()) {
            this.supportedTgtDs.addAll(dss);
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getSpecies() {
        return this.species;
    }

    public void close() throws IDMapperException {
        this.closed = true;
    }

    private Set<DataSource> getSupportedSrcDataSources() throws IDMapperException {
        HashSet<DataSource> dss = new HashSet<DataSource>();
        Set<String> domains = this.stub.availableDomains(this.authority, this.species);
        for (String domain : domains) {
            dss.add(DataSource.getByFullName((String)domain));
        }
        return dss;
    }

    private Map<DataSource, Set<DataSource>> getMapSrcTgt() throws IDMapperException {
        HashMap<DataSource, Set<DataSource>> map = new HashMap<DataSource, Set<DataSource>>();
        Set<String> domains = this.stub.availableDomains(this.authority, this.species);
        for (String domain : domains) {
            DataSource src = DataSource.getByFullName((String)domain);
            Set<String> ranges = this.stub.availableRanges(this.authority, this.species, domain);
            HashSet<DataSource> tgts = new HashSet<DataSource>();
            for (String range : ranges) {
                tgts.add(DataSource.getByFullName((String)range));
            }
            map.put(src, tgts);
        }
        return map;
    }

    public Set<Xref> freeSearch(String text, int limit) throws IDMapperException {
        throw new UnsupportedOperationException();
    }

    public IDMapperCapabilities getCapabilities() {
        return this.caps;
    }

    public boolean isConnected() {
        return !this.closed;
    }

    public Map<Xref, Set<Xref>> mapID(Collection<Xref> srcXrefs, DataSource ... resultDs) throws IDMapperException {
        HashMap<String, Xref> ids;
        String src;
        if (srcXrefs == null) {
            throw new NullPointerException("srcXrefs or tgtDataSources cannot be null.");
        }
        HashMap<Xref, Set<Xref>> result = new HashMap<Xref, Set<Xref>>();
        HashSet<DataSource> dsFilter = new HashSet<DataSource>(Arrays.asList(resultDs));
        HashMap<String, HashMap<String, Xref>> mapSrcTypeIDXrefs = new HashMap<String, HashMap<String, Xref>>();
        for (Xref xref : srcXrefs) {
            DataSource dataSource = xref.getDataSource();
            if (!this.supportedSrcDs.contains(dataSource)) continue;
            src = dataSource.getFullName();
            ids = (HashMap<String, Xref>)mapSrcTypeIDXrefs.get(src);
            if (ids == null) {
                ids = new HashMap<String, Xref>();
                mapSrcTypeIDXrefs.put(src, ids);
            }
            ids.put(xref.getId(), xref);
        }
        HashMap mapSrcTgt = new HashMap();
        for (Map.Entry<DataSource, Set<DataSource>> entry : this.mapSrcDsTgtDs.entrySet()) {
            src = entry.getKey().getFullName();
            if (!mapSrcTypeIDXrefs.containsKey(src)) continue;
            HashSet<String> set = new HashSet<String>();
            mapSrcTgt.put(src, set);
            for (DataSource dataSource : entry.getValue()) {
                if (resultDs.length != 0 && !dsFilter.contains(dataSource)) continue;
                set.add(dataSource.getFullName());
            }
        }
        for (Map.Entry<Object, Set<Object>> entry : mapSrcTypeIDXrefs.entrySet()) {
            src = (String)entry.getKey();
            ids = ((Map)((Object)entry.getValue())).keySet();
            Set tgts = (Set)mapSrcTgt.get(src);
            for (String tgt : tgts) {
                Map<String, Set<String>> res = this.stub.translate(this.authority, this.species, src, tgt, (Set<String>)((Object)ids));
                for (Map.Entry<String, Set<String>> entryRes : res.entrySet()) {
                    String srcId = entryRes.getKey();
                    Set<String> tgtIds = entryRes.getValue();
                    if (tgtIds == null) continue;
                    Xref srcXref = (Xref)((Map)mapSrcTypeIDXrefs.get(src)).get(srcId);
                    HashSet<Xref> tgtXrefs = (HashSet<Xref>)result.get(srcXref);
                    if (tgtXrefs == null) {
                        tgtXrefs = new HashSet<Xref>();
                        result.put(srcXref, tgtXrefs);
                    }
                    for (String tgtId : tgtIds) {
                        Xref tgtXref = new Xref(tgtId, DataSource.getByFullName((String)tgt));
                        tgtXrefs.add(tgtXref);
                    }
                }
            }
        }
        return result;
    }

    public boolean xrefExists(Xref xref) throws IDMapperException {
        throw new UnsupportedOperationException("xrefExists operation not supported for synergizer");
    }

    static {
        BridgeDb.register((String)"idmapper-synergizer", (org.bridgedb.Driver)new Driver());
    }

    private class SynergizerCapabilities
    extends AbstractIDMapperCapabilities {
        public SynergizerCapabilities() throws IDMapperException {
            super(null, false, null);
        }

        public Set<DataSource> getSupportedSrcDataSources() throws IDMapperException {
            return IDMapperSynergizer.this.supportedSrcDs;
        }

        public Set<DataSource> getSupportedTgtDataSources() throws IDMapperException {
            return IDMapperSynergizer.this.supportedTgtDs;
        }

        public boolean isMappingSupported(DataSource src, DataSource tgt) throws IDMapperException {
            if (src == null || tgt == null) {
                return false;
            }
            Map map = IDMapperSynergizer.this.mapSrcDsTgtDs;
            return this.getSupportedSrcDataSources().contains(src) && ((Set)map.get(src)).contains(tgt);
        }
    }

    private static class Driver
    implements org.bridgedb.Driver {
        private Driver() {
        }

        public IDMapper connect(String location) throws IDMapperException {
            String baseURL = "http://llama.mshri.on.ca/cgi/synergizer/serv";
            Map info = InternalUtils.parseLocation((String)location, (String[])new String[]{"authority", "species"});
            if (info.containsKey("BASE")) {
                baseURL = (String)info.get("BASE");
            }
            String authority = (String)info.get("authority");
            String species = (String)info.get("species");
            return new IDMapperSynergizer(authority, species, baseURL);
        }
    }
}

