/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.webservice.synergizer;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bridgedb.IDMapperException;
import org.json.JSONException;
import synergizer.SynergizerClient;

public class SynergizerStub {
    public static final String defaultBaseURL = "http://llama.mshri.on.ca/cgi/synergizer/serv";
    private Map<String, Map<String, Map<String, Set<String>>>> mapAuthSpeciesDomainRange = null;
    private static Map<String, SynergizerStub> instances = new HashMap<String, SynergizerStub>();
    private SynergizerClient client;

    public static SynergizerStub getInstance() throws IOException {
        return SynergizerStub.getInstance(defaultBaseURL);
    }

    public static SynergizerStub getInstance(String baseUrl) throws IOException {
        if (baseUrl == null) {
            throw new IllegalArgumentException("base url cannot be null");
        }
        SynergizerStub instance = instances.get(baseUrl);
        if (instance == null) {
            instance = new SynergizerStub(baseUrl);
            instances.put(baseUrl, instance);
        }
        return instance;
    }

    private SynergizerStub(String baseUrl) throws IOException {
        this.client = new SynergizerClient(new URL(baseUrl));
    }

    public Set<String> availableAuthorities() throws IDMapperException {
        if (this.mapAuthSpeciesDomainRange == null) {
            Set auths;
            try {
                auths = this.client.availableAuthorities();
            }
            catch (IOException e) {
                throw new IDMapperException((Throwable)e);
            }
            catch (JSONException e) {
                throw new IDMapperException((Throwable)e);
            }
            this.mapAuthSpeciesDomainRange = new HashMap<String, Map<String, Map<String, Set<String>>>>();
            for (String auth : auths) {
                this.mapAuthSpeciesDomainRange.put(auth, null);
            }
        }
        return this.mapAuthSpeciesDomainRange.keySet();
    }

    public Set<String> availableSpecies(String authority) throws IDMapperException {
        if (authority == null) {
            return new HashSet<String>(0);
        }
        if (!this.availableAuthorities().contains(authority)) {
            return new HashSet<String>(0);
        }
        Map<String, Map<String, Set<String>>> mapSpeciesDomainRange = this.mapAuthSpeciesDomainRange.get(authority);
        if (mapSpeciesDomainRange == null) {
            Set species;
            try {
                species = this.client.availableSpecies(authority);
            }
            catch (IOException e) {
                throw new IDMapperException((Throwable)e);
            }
            catch (JSONException e) {
                throw new IDMapperException((Throwable)e);
            }
            mapSpeciesDomainRange = new HashMap<String, Map<String, Set<String>>>();
            for (String sp : species) {
                mapSpeciesDomainRange.put(sp, null);
            }
            this.mapAuthSpeciesDomainRange.put(authority, mapSpeciesDomainRange);
        }
        return mapSpeciesDomainRange.keySet();
    }

    public Set<String> availableDomains(String authority, String species) throws IDMapperException {
        if (authority == null || species == null) {
            return new HashSet<String>(0);
        }
        if (!this.availableSpecies(authority).contains(species)) {
            return new HashSet<String>(0);
        }
        Map<String, Set<String>> mapDomainRange = this.mapAuthSpeciesDomainRange.get(authority).get(species);
        if (mapDomainRange == null) {
            Set domains;
            try {
                domains = this.client.availableDomains(authority, species);
            }
            catch (IOException e) {
                throw new IDMapperException((Throwable)e);
            }
            catch (JSONException e) {
                throw new IDMapperException((Throwable)e);
            }
            mapDomainRange = new HashMap<String, Set<String>>();
            for (String domain : domains) {
                mapDomainRange.put(domain, null);
            }
            this.mapAuthSpeciesDomainRange.get(authority).put(species, mapDomainRange);
        }
        return mapDomainRange.keySet();
    }

    public Set<String> availableRanges(String authority, String species, String domain) throws IDMapperException {
        if (authority == null || species == null || domain == null) {
            return new HashSet<String>(0);
        }
        if (!this.availableDomains(authority, species).contains(domain)) {
            return new HashSet<String>(0);
        }
        Set ranges = this.mapAuthSpeciesDomainRange.get(authority).get(species).get(domain);
        if (ranges == null) {
            try {
                ranges = this.client.availableRanges(authority, species, domain);
            }
            catch (IOException e) {
                throw new IDMapperException((Throwable)e);
            }
            catch (JSONException e) {
                throw new IDMapperException((Throwable)e);
            }
            this.mapAuthSpeciesDomainRange.get(authority).get(species).put(domain, ranges);
        }
        return ranges;
    }

    public Map<String, Set<String>> translate(String authority, String species, String domain, String range, Set<String> ids) throws IDMapperException {
        SynergizerClient.TranslateResult res;
        try {
            res = this.client.translate(authority, species, domain, range, ids);
        }
        catch (IOException e) {
            throw new IDMapperException((Throwable)e);
        }
        catch (JSONException e) {
            throw new IDMapperException((Throwable)e);
        }
        return res.translationMap();
    }
}

