/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.client.BiopaxValidatorClient;
import org.biopax.paxtools.controller.Cloner;
import org.biopax.paxtools.controller.Completer;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.Integrator;
import org.biopax.paxtools.controller.Merger;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.converter.LevelUpgrader;
import org.biopax.paxtools.converter.psi.PsiToBiopax3Converter;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.io.gsea.GSEAConverter;
import org.biopax.paxtools.io.sbgn.L3ToSBGNPDConverter;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.entity;
import org.biopax.paxtools.model.level3.ControlledVocabulary;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.pattern.miner.BlacklistGenerator;
import org.biopax.paxtools.pattern.miner.CommonIDFetcher;
import org.biopax.paxtools.pattern.miner.CustomFormat;
import org.biopax.paxtools.pattern.miner.IDFetcher;
import org.biopax.paxtools.pattern.miner.OldFormatWriter;
import org.biopax.paxtools.pattern.miner.OutputColumn;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.biopax.paxtools.pattern.miner.SIFSearcher;
import org.biopax.paxtools.pattern.miner.SIFToText;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.biopax.paxtools.query.QueryExecuter;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.query.wrapperL3.Filter;
import org.biopax.validator.jaxb.Behavior;
import org.mskcc.psibiopax.converter.PSIMIBioPAXConverter;

public class PaxtoolsMain {
    public static Log log = LogFactory.getLog(PaxtoolsMain.class);
    private static SimpleIOHandler io = new SimpleIOHandler();
    private static final Object NULL = new Object(){

        public String toString() {
            return "NULL";
        }
    };
    private static final Object EMPTY = new Object(){

        public String toString() {
            return "EMPTY";
        }
    };

    public static void main(String[] argv) throws IOException, InvocationTargetException, IllegalAccessException {
        io.mergeDuplicates(true);
        if (argv.length == 0) {
            PaxtoolsMain.help();
        } else {
            String command = argv[0];
            if (command.startsWith("--")) {
                command = command.substring(2);
            }
            Command.valueOf(command).run(argv);
        }
    }

    public static void fromPsimi(String[] argv) throws IOException {
        System.out.println("PSI-MI to BioPAX Conversion Tool");
        System.out.println("Supports PSI-MI Level 2.5 (compact) model and BioPAX Level 2 or 3.");
        Integer bpLevelArg = null;
        try {
            bpLevelArg = Integer.valueOf(argv[1]);
            if (bpLevelArg != 2 && bpLevelArg != 3) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Incorrect BioPAX level specified: " + argv[1] + " .  Please select level 2 or 3.");
        }
        String inputFile = argv[2];
        String outputFile = argv[3];
        if (!new File(inputFile).exists()) {
            System.err.println("input filename: " + inputFile + " does not exist!");
        }
        try {
            BioPAXLevel bpLevel = bpLevelArg == 2 ? BioPAXLevel.L2 : BioPAXLevel.L3;
            FileInputStream fis = new FileInputStream(inputFile);
            FileOutputStream fos = new FileOutputStream(outputFile);
            PSIMIBioPAXConverter converter = argv.length > 4 ? new PSIMIBioPAXConverter(bpLevel, argv[4]) : new PSIMIBioPAXConverter(bpLevel);
            converter.convert((InputStream)fis, (OutputStream)fos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void toGSEA(String[] argv) throws IOException {
        Model model = io.convertFromOWL((InputStream)new FileInputStream(argv[1]));
        Boolean specCheckEnabled = argv.length > 4 ? new Boolean(argv[4]) : Boolean.FALSE;
        new GSEAConverter(argv[3], specCheckEnabled.booleanValue()).writeToGSEA(model, (OutputStream)new FileOutputStream(argv[2]));
    }

    public static void getNeighbors(String[] argv) throws IOException {
        String in = argv[1];
        String[] ids = argv[2].split(",");
        String out = argv[3];
        Model model = io.convertFromOWL((InputStream)new FileInputStream(in));
        HashSet<BioPAXElement> elements = new HashSet<BioPAXElement>();
        for (String id : ids) {
            BioPAXElement e = model.getByID(id.toString());
            if (e != null && (e instanceof Entity || e instanceof entity)) {
                elements.add(e);
                continue;
            }
            log.warn((Object)("Source element not found: " + id));
        }
        Set result = QueryExecuter.runNeighborhood(elements, (Model)model, (int)1, (Direction)Direction.BOTHSTREAM, (Filter[])new Filter[0]);
        Completer c = new Completer(io.getEditorMap());
        result = c.complete((Collection)result, model);
        Cloner cln = new Cloner(io.getEditorMap(), io.getFactory());
        model = cln.clone(model, result);
        if (model != null) {
            log.info((Object)("Elements in the result model: " + model.getObjects().size()));
            io.convertToOWL(model, (OutputStream)new FileOutputStream(out));
        } else {
            log.error((Object)"NULL model returned.");
        }
    }

    public static void fetch(String[] argv) throws IOException {
        String in = argv[1];
        String[] ids = argv[2].split(",");
        String out = argv[3];
        Model model = io.convertFromOWL((InputStream)new FileInputStream(in));
        io.setFactory(model.getLevel().getDefaultFactory());
        io.convertToOWL(model, (OutputStream)new FileOutputStream(out), ids);
    }

    public static void toLevel3(String[] argv) throws IOException {
        String input = argv[1];
        String output = argv[2];
        FileInputStream is = new FileInputStream(input);
        FileOutputStream os = new FileOutputStream(output);
        boolean forcePsiInteractionToComplex = false;
        String val = System.getProperty("paxtools.converter.psi.interaction");
        if ("complex".equalsIgnoreCase(val)) {
            forcePsiInteractionToComplex = true;
        }
        Type type = PaxtoolsMain.detect(input);
        try {
            switch (type) {
                case BIOPAX: {
                    Model model = io.convertFromOWL((InputStream)is);
                    model = new LevelUpgrader().filter(model);
                    if (model != null) {
                        io.setFactory(model.getLevel().getDefaultFactory());
                        io.convertToOWL(model, (OutputStream)os);
                    }
                    break;
                }
                case PSIMI: {
                    PsiToBiopax3Converter psimiConverter = new PsiToBiopax3Converter();
                    psimiConverter.convert((InputStream)is, (OutputStream)os, forcePsiInteractionToComplex);
                    os.close();
                    break;
                }
                default: {
                    PsiToBiopax3Converter psimiConverter = new PsiToBiopax3Converter();
                    psimiConverter.convertTab((InputStream)is, (OutputStream)os, forcePsiInteractionToComplex);
                    os.close();
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert " + input + "to BioPAX L3", e);
        }
    }

    private static Type detect(String input) {
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(input));
            int linesToCheck = 20;
            while (linesToCheck-- > 0) {
                sb.append(reader.readLine()).append('\n');
            }
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String buf = sb.toString();
        if (buf.contains("<rdf:RDF") && buf.contains("http://www.biopax.org/release/biopax")) {
            return Type.BIOPAX;
        }
        if (buf.contains("<entrySet") && buf.contains("http://psidev.sourceforge.net/mi/rel25/")) {
            return Type.PSIMI;
        }
        return Type.PSIMITAB;
    }

    public static void toSBGN(String[] argv) throws IOException {
        String input = argv[1];
        String output = argv[2];
        Model model = io.convertFromOWL((InputStream)new FileInputStream(input));
        L3ToSBGNPDConverter l3ToSBGNPDConverter = new L3ToSBGNPDConverter();
        l3ToSBGNPDConverter.writeSBGN(model, output);
    }

    public static void validate(String[] argv) throws IOException {
        block16: {
            String input = argv[1];
            String output = argv[2];
            BiopaxValidatorClient.RetFormat outf = BiopaxValidatorClient.RetFormat.HTML;
            boolean fix = false;
            Integer maxErrs = null;
            Behavior level = null;
            String profile = null;
            for (int i = 3; i < argv.length; ++i) {
                if ("html".equalsIgnoreCase(argv[i])) {
                    outf = BiopaxValidatorClient.RetFormat.HTML;
                    continue;
                }
                if ("xml".equalsIgnoreCase(argv[i])) {
                    outf = BiopaxValidatorClient.RetFormat.XML;
                    continue;
                }
                if ("biopax".equalsIgnoreCase(argv[i])) {
                    outf = BiopaxValidatorClient.RetFormat.OWL;
                    continue;
                }
                if ("auto-fix".equalsIgnoreCase(argv[i])) {
                    fix = true;
                    continue;
                }
                if ("only-errors".equalsIgnoreCase(argv[i])) {
                    level = Behavior.ERROR;
                    continue;
                }
                if (argv[i].toLowerCase().startsWith("maxerrors=")) {
                    String num = argv[i].substring(10);
                    maxErrs = Integer.valueOf(num);
                    continue;
                }
                if (!"notstrict".equalsIgnoreCase(argv[i])) continue;
                profile = "notstrict";
            }
            HashSet<File> files = new HashSet<File>();
            File fileOrDir = new File(input);
            if (!fileOrDir.canRead()) {
                System.out.println("Cannot read " + input);
            }
            if (fileOrDir.isDirectory()) {
                FilenameFilter filter = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".owl");
                    }
                };
                for (String s : fileOrDir.list(filter)) {
                    files.add(new File(fileOrDir.getCanonicalPath() + File.separator + s));
                }
            } else {
                files.add(fileOrDir);
            }
            FileOutputStream os = new FileOutputStream(output);
            try {
                if (files.isEmpty()) break block16;
                BiopaxValidatorClient val = new BiopaxValidatorClient();
                val.validate(fix, profile, outf, level, maxErrs, null, files.toArray(new File[0]), os);
            }
            catch (Exception ex) {
                String msg = "Unable to check with the biopax-validator web service: \n " + ex.toString() + "\n Fall-back: trying to parse the file(s) with paxtools " + "(up to the first syntax error in each file)...\n";
                log.error((Object)msg, (Throwable)ex);
                ((OutputStream)os).write(msg.getBytes());
                for (File f : files) {
                    Model m = null;
                    msg = "";
                    try {
                        m = io.convertFromOWL((InputStream)new FileInputStream(f));
                        msg = "Model that contains " + m.getObjects().size() + " elements is successfully created from " + f.getPath() + " (check the console output for warnings).\n";
                        ((OutputStream)os).write(msg.getBytes());
                    }
                    catch (Exception e) {
                        msg = "Error: " + e + " in building a BioPAX Model from: " + f.getPath() + "\n";
                        ((OutputStream)os).write(msg.getBytes());
                        e.printStackTrace();
                        log.error((Object)msg);
                    }
                    os.flush();
                }
            }
        }
    }

    public static void toSifnx(String[] argv) throws IOException {
        CommonIDFetcher idFetcher = new CommonIDFetcher();
        idFetcher.setUseUniprotIDs(argv.length > 3 && argv[3].equals("uniprot"));
        SIFSearcher searcher = new SIFSearcher((IDFetcher)idFetcher, (SIFType[])SIFEnum.values());
        File blacklistFile = new File("blacklist.txt");
        if (blacklistFile.exists()) {
            log.info((Object)"toSifnx: will use the blacklist.txt (found in the current directory)");
            searcher.setBlacklist(new Blacklist((InputStream)new FileInputStream(blacklistFile)));
        } else {
            log.info((Object)"toSifnx: not blacklisting ubiquitous molecules (no blacklist.txt found)");
        }
        Model model = PaxtoolsMain.getModel((BioPAXIOHandler)io, argv[1]);
        ModelUtils.mergeEquivalentInteractions((Model)model);
        Set binaryInts = searcher.searchSIF(model);
        OldFormatWriter.write((Set)binaryInts, (OutputStream)new FileOutputStream(argv[2]));
    }

    public static void toSif(String[] argv) throws IOException {
        CommonIDFetcher idFetcher = new CommonIDFetcher();
        ArrayList<String> otherParam = new ArrayList<String>();
        otherParam.addAll(Arrays.asList(argv).subList(3, argv.length));
        idFetcher.setUseUniprotIDs(otherParam.contains("uniprot"));
        SIFSearcher searcher = new SIFSearcher((IDFetcher)idFetcher, (SIFType[])SIFEnum.values());
        File blacklistFile = new File("blacklist.txt");
        if (blacklistFile.exists()) {
            log.info((Object)"toSif: will use the blacklist.txt (found in the current directory)");
            searcher.setBlacklist(new Blacklist((InputStream)new FileInputStream(blacklistFile)));
        } else {
            log.info((Object)"toSif: not blacklisting ubiquitous molecules (no blacklist.txt found)");
        }
        ArrayList<String> fieldList = new ArrayList<String>();
        for (String param : otherParam) {
            OutputColumn.Type type = OutputColumn.Type.getType((String)param);
            if ((type == null || type == OutputColumn.Type.CUSTOM) && !param.contains("/")) continue;
            fieldList.add(param);
        }
        Model model = PaxtoolsMain.getModel((BioPAXIOHandler)io, argv[1]);
        ModelUtils.mergeEquivalentInteractions((Model)model);
        if (fieldList.isEmpty()) {
            searcher.searchSIF(model, (OutputStream)new FileOutputStream(argv[2]), false);
        } else if (fieldList.size() == 1 && fieldList.contains(OutputColumn.Type.MEDIATOR.name().toLowerCase())) {
            searcher.searchSIF(model, (OutputStream)new FileOutputStream(argv[2]), true);
        } else {
            searcher.searchSIF(model, (OutputStream)new FileOutputStream(argv[2]), (SIFToText)new CustomFormat(fieldList.toArray(new String[fieldList.size()])));
        }
    }

    public static void integrate(String[] argv) throws IOException {
        Model model1 = PaxtoolsMain.getModel((BioPAXIOHandler)io, argv[1]);
        Model model2 = PaxtoolsMain.getModel((BioPAXIOHandler)io, argv[2]);
        Integrator integrator = new Integrator((EditorMap)SimpleEditorMap.get((BioPAXLevel)model1.getLevel()), model1, new Model[]{model2});
        integrator.integrate();
        io.setFactory(model1.getLevel().getDefaultFactory());
        io.convertToOWL(model1, (OutputStream)new FileOutputStream(argv[3]));
    }

    public static void merge(String[] argv) throws IOException {
        Model model1 = PaxtoolsMain.getModel((BioPAXIOHandler)io, argv[1]);
        Model model2 = PaxtoolsMain.getModel((BioPAXIOHandler)io, argv[2]);
        Merger merger = new Merger((EditorMap)SimpleEditorMap.get((BioPAXLevel)model1.getLevel()));
        merger.merge(model1, new Model[]{model2});
        io.setFactory(model1.getLevel().getDefaultFactory());
        io.convertToOWL(model1, (OutputStream)new FileOutputStream(argv[3]));
    }

    public static void blacklist(String[] argv) throws IOException {
        Model model = PaxtoolsMain.getModel((BioPAXIOHandler)io, argv[1]);
        BlacklistGenerator gen = new BlacklistGenerator();
        Blacklist blacklist = gen.generateBlacklist(model);
        blacklist.write((OutputStream)new FileOutputStream(argv[2]));
    }

    static void help() {
        System.out.println("(Paxtools Console) Available Operations:\n");
        for (Command cmd : Command.values()) {
            System.out.println(cmd.name() + " " + cmd.description);
        }
    }

    private static Model getModel(BioPAXIOHandler io, String fName) throws FileNotFoundException {
        FileInputStream file = new FileInputStream(fName);
        return io.convertFromOWL((InputStream)file);
    }

    public static void summarize(String[] argv) throws IOException {
        Model model = PaxtoolsMain.getModel((BioPAXIOHandler)io, argv[1]);
        PaxtoolsMain.summarize(model, argv.length > 2 ? new PrintStream(argv[2]) : null);
    }

    public static void summarize(Model model, PrintStream out) throws IOException {
        String[] stringArray;
        if (out == null) {
            out = System.out;
        }
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        SimpleEditorMap em = model.getLevel() == BioPAXLevel.L3 ? SimpleEditorMap.L3 : SimpleEditorMap.L2;
        for (Class<? extends BioPAXElement> clazz : PaxtoolsMain.sortToName(em.getKnownSubClassesOf(BioPAXElement.class))) {
            Set<BioPAXElement> set = model.getObjects(clazz);
            int initialSize = set.size();
            set = PaxtoolsMain.filterToExactClass((Set<? extends BioPAXElement>)set, clazz);
            String s = clazz.getSimpleName() + " = " + set.size();
            if (initialSize != set.size()) {
                s = s + " (and " + (initialSize - set.size()) + " children)";
            }
            out.println(s);
            Set editors = em.getEditorsOf(clazz);
            for (PropertyEditor editor : editors) {
                Set values;
                Method getMethod = editor.getGetMethod();
                Class<?> returnType = getMethod.getReturnType();
                HashMap<Object, Integer> cnt = new HashMap<Object, Integer>();
                if (returnType.isEnum() || PaxtoolsMain.implementsInterface(returnType, ControlledVocabulary.class)) {
                    for (BioPAXElement ele : set) {
                        values = editor.getValueFromBean(ele);
                        if (values.isEmpty()) {
                            PaxtoolsMain.increaseCnt(cnt, NULL);
                            continue;
                        }
                        PaxtoolsMain.increaseCnt(cnt, values.iterator().next());
                    }
                } else if (returnType.equals(Set.class) && PaxtoolsMain.implementsInterface(editor.getRange(), ControlledVocabulary.class)) {
                    for (BioPAXElement ele : set) {
                        values = editor.getValueFromBean(ele);
                        if (values.isEmpty()) {
                            PaxtoolsMain.increaseCnt(cnt, EMPTY);
                        }
                        for (Object val : values) {
                            PaxtoolsMain.increaseCnt(cnt, val);
                        }
                    }
                }
                if (cnt.isEmpty()) continue;
                String name = "-" + (returnType.equals(Set.class) ? editor.getRange().getSimpleName() : returnType.getSimpleName());
                out.print("\t" + name + ":");
                for (Object key : PaxtoolsMain.getOrdering(cnt)) {
                    out.print("\t" + key + " = " + cnt.get(key));
                }
                out.println();
            }
        }
        if (model.getLevel() == BioPAXLevel.L3) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "UnificationXref/db";
            stringArray = stringArray2;
            stringArray2[1] = "RelationshipXref/db";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "unificationXref/DB";
            stringArray = stringArray3;
            stringArray3[1] = "relationshipXref/DB";
        }
        String[] props = stringArray;
        out.println("\nOther property counts\n");
        for (String prop : props) {
            HashMap<Object, Integer> cnt = new HashMap<Object, Integer>();
            ArrayList<String> valList = new ArrayList<String>();
            PathAccessor acc = new PathAccessor(prop, model.getLevel());
            boolean isString = false;
            for (Object o : acc.getValueFromModel(model)) {
                if (o instanceof String) {
                    isString = true;
                }
                String s = o.toString();
                valList.add(s);
                if (!cnt.containsKey(s)) {
                    cnt.put(s, 1);
                    continue;
                }
                cnt.put(s, (Integer)cnt.get(s) + 1);
            }
            out.println(prop + "\t(" + cnt.size() + " distinct values):");
            hm.put(prop, cnt.size());
            if (isString) {
                Collections.sort(valList);
                for (String s : valList) {
                    out.print("\t" + s);
                }
            } else {
                for (Object key : PaxtoolsMain.getOrdering(cnt)) {
                    out.print("\t" + key + " = " + cnt.get(key));
                }
            }
            out.println();
        }
    }

    private static List<Class<? extends BioPAXElement>> sortToName(Set<? extends Class<? extends BioPAXElement>> classes) {
        ArrayList<Class<? extends BioPAXElement>> list = new ArrayList<Class<? extends BioPAXElement>>(classes);
        Collections.sort(list, new Comparator<Class<? extends BioPAXElement>>(){

            @Override
            public int compare(Class<? extends BioPAXElement> clazz1, Class<? extends BioPAXElement> clazz2) {
                return clazz1.getName().substring(clazz1.getName().lastIndexOf(".") + 1).compareTo(clazz2.getName().substring(clazz2.getName().lastIndexOf(".") + 1));
            }
        });
        return list;
    }

    private static List<Object> getOrdering(final Map<Object, Integer> map) {
        ArrayList<Object> list = new ArrayList<Object>(map.keySet());
        Collections.sort(list, new Comparator<Object>(){

            @Override
            public int compare(Object key1, Object key2) {
                int cnt2;
                int cnt1 = (Integer)map.get(key1);
                if (cnt1 == (cnt2 = ((Integer)map.get(key2)).intValue())) {
                    return key1.toString().compareTo(key2.toString());
                }
                return cnt2 - cnt1;
            }
        });
        return list;
    }

    private static Set<BioPAXElement> filterToExactClass(Set<? extends BioPAXElement> classSet, Class clazz) {
        HashSet<BioPAXElement> exact = new HashSet<BioPAXElement>();
        for (BioPAXElement bioPAXElement : classSet) {
            if (!bioPAXElement.getModelInterface().equals(clazz)) continue;
            exact.add(bioPAXElement);
        }
        return exact;
    }

    private static boolean implementsInterface(Class clazz, Class inter) {
        for (Class<?> anInter : clazz.getInterfaces()) {
            if (!anInter.equals(inter)) continue;
            return true;
        }
        return false;
    }

    private static void increaseCnt(Map<Object, Integer> cnt, Object key) {
        if (!cnt.containsKey(key)) {
            cnt.put(key, 0);
        }
        cnt.put(key, cnt.get(key) + 1);
    }

    static enum Command {
        merge("<file1> <file2> <output>\n\t- merges file2 into file1 and writes it into output"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.merge(argv);
            }
        }
        ,
        toSif("<file1> <output> [hgnc|uniprot]\n\t- converts model to the simple interaction format; will use blacklist.txt file in the current directory, if present"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.toSif(argv);
            }
        }
        ,
        toSifnx("<file1> <output> [hgnc|uniprot] [mediator] [pubmed] [pathway] [resource] [source_loc] [target_loc] [path/to/a/mediator/field]\n\t- converts model to the extended simple interaction format; will use blacklist.txt file in the current directory, if present"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.toSifnx(argv);
            }
        }
        ,
        toSbgn("<biopax.owl> <output.sbgn>\n\t- converts model to the SBGN format."){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.toSBGN(argv);
            }
        }
        ,
        validate("<path> <out> [xml|html|biopax] [auto-fix] [only-errors] [maxerrors=n] [notstrict]\n\t- validate BioPAX file/directory (up to ~25MB in total size, -\n\totherwise download and run the stand-alone validator)\n\tin the directory using the online validator service\n\t(generates html or xml report, or gets the processed biopax\n\t(cannot be perfect though) see http://www.biopax.org/validator)"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.validate(argv);
            }
        }
        ,
        integrate("<file1> <file2> <output>\n\t- integrates file2 into file1 and writes it into output (experimental)"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.integrate(argv);
            }
        }
        ,
        toLevel3("<file1> <output>\n\t- converts BioPAX level 1 or 2, PSI-MI 2.5 and PSI-MITAB to the level 3 file;\nuse -Dpaxtools.converter.psi.interaction=complex java option \nto force PSI Interaction to BioPAX Complex convertion instead of \nto MolecularInteraction (default)."){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.toLevel3(argv);
            }
        }
        ,
        fromPsimi("<level> <file1> <output> [<xml:base>]\n\t- (deprecated) converts PSI-MI Level 2.5 to biopax level 2 or 3 file"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.fromPsimi(argv);
            }
        }
        ,
        toGSEA("<file1> <output> <database> [crossSpeciesCheck]\n\t- converts Level 1 or 2 or 3 to GSEA output.\n\tUses that database identifier or the biopax URI if database is \"NONE\".\n\tCross species check ensures participant protein is from same species\n\tas pathway (set to true or false; if false, taxonomy/organism value there will be always 'unspecified')."){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.toGSEA(argv);
            }
        }
        ,
        fetch("<file1> <id1,id2,..> <output>\n\t- extracts a sub-model from file1 and writes BioPAX to output"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.fetch(argv);
            }
        }
        ,
        getNeighbors("<file1> <id1,id2,..> <output>\n\t- nearest neighborhood graph query (id1,id2 - of Entity sub-class only)"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.getNeighbors(argv);
            }
        }
        ,
        summarize("<file> [<output>]\n\t- prints a summary of the contents of the model to the output file (if not provided - to stdout)"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.summarize(argv);
            }
        }
        ,
        blacklist("<file> <output>\n\t- creates a blacklist of ubiquitous small molecules, like ATP, from the BioPAX model and writes it to the output file. The blacklist can be used with paxtools graph queries or when converting from the SAME BioPAX data to the SIF formats."){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.blacklist(argv);
            }
        }
        ,
        help("\t- prints this screen and exits"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.help();
            }
        };

        String description;
        int params;

        private Command(String description) {
            this.description = description;
        }

        public abstract void run(String[] var1) throws IOException;
    }

    private static enum Type {
        BIOPAX,
        PSIMI,
        PSIMITAB;

    }
}

