/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.Fetcher;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.Traverser;
import org.biopax.paxtools.controller.Visitor;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.pathway;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.protein;
import org.biopax.paxtools.model.level2.unificationXref;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.paxtools.util.Filter;

public class ProteinNameLister {
    private static Log log = LogFactory.getLog(ProteinNameLister.class);
    private static Fetcher fetcher;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("\nUse Parameter: path (to biopax OWL files)\n");
            System.exit(-1);
        }
        SimpleIOHandler reader = new SimpleIOHandler();
        String pathname = args[0];
        File testDir = new File(pathname);
        Filter<PropertyEditor> nextStepPropertyFilter = new Filter<PropertyEditor>(){

            public boolean filter(PropertyEditor editor) {
                return !editor.getProperty().equals("NEXT-STEP");
            }
        };
        fetcher = new Fetcher((EditorMap)SimpleEditorMap.L2, new Filter[]{nextStepPropertyFilter});
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("owl");
            }
        };
        for (String s : testDir.list(filter)) {
            try {
                ProteinNameLister.process(pathname, s, (BioPAXIOHandler)reader);
            }
            catch (Exception e) {
                log.error((Object)("Failed at testing " + s), (Throwable)e);
            }
        }
    }

    private static void process(String pathname, String name, BioPAXIOHandler reader) throws FileNotFoundException {
        System.out.println("--------------" + name + "---------");
        Model model = reader.convertFromOWL((InputStream)new FileInputStream(pathname + "/" + name));
        ProteinNameLister.listProteinUnificationXrefsPerPathway(model);
    }

    public static void listProteinUnificationXrefsPerPathway(Model model) {
        Set pathways = model.getObjects(pathway.class);
        for (pathway aPathway : pathways) {
            System.out.println(aPathway.getNAME());
            Model onePathwayModel = BioPAXLevel.L2.getDefaultFactory().createModel();
            fetcher.fetch((BioPAXElement)aPathway, onePathwayModel);
            Set proteins = onePathwayModel.getObjects(protein.class);
            for (protein aProtein : proteins) {
                System.out.println("\t" + aProtein.getNAME());
                ClassFilterSet xrefs = new ClassFilterSet(aProtein.getXREF(), unificationXref.class);
                for (unificationXref x : xrefs) {
                    System.out.println("\t\t" + x.getDB() + ":" + x.getID());
                }
            }
        }
    }

    public static void listUnificationXrefsPerPathway(Model model) {
        Visitor visitor = new Visitor(){

            public void visit(BioPAXElement domain, Object range, Model model, PropertyEditor editor) {
                if (range instanceof physicalEntity) {
                    physicalEntity pe = (physicalEntity)range;
                    ClassFilterSet unis = new ClassFilterSet(pe.getXREF(), unificationXref.class);
                    for (unificationXref uni : unis) {
                        System.out.println("pe.getNAME() = " + pe.getNAME());
                        System.out.println("uni = " + uni.getID());
                    }
                }
            }
        };
        Traverser traverser = new Traverser((EditorMap)SimpleEditorMap.L2, visitor, new Filter[0]);
        Set pathways = model.getObjects(pathway.class);
        for (pathway pathway2 : pathways) {
            traverser.traverse((BioPAXElement)pathway2, model);
        }
    }
}

