/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.ArrayUtils;
import org.biopax.paxtools.controller.AbstractTraverser;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.Traverser;
import org.biopax.paxtools.controller.Visitor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.util.Filter;

public class Fetcher {
    private final EditorMap editorMap;
    private final Filter<PropertyEditor>[] filters;
    private boolean skipSubPathways;
    public static final Filter<PropertyEditor> nextStepFilter = new Filter<PropertyEditor>(){

        @Override
        public boolean filter(PropertyEditor editor) {
            return !editor.getProperty().equals("nextStep") && !editor.getProperty().equals("NEXT-STEP");
        }
    };
    public static final Filter<PropertyEditor> evidenceFilter = new Filter<PropertyEditor>(){

        @Override
        public boolean filter(PropertyEditor editor) {
            return !editor.getProperty().equals("evidence") && !editor.getProperty().equals("EVIDENCE");
        }
    };
    public static final Filter<PropertyEditor> objectPropertiesOnlyFilter = new Filter<PropertyEditor>(){

        @Override
        public boolean filter(PropertyEditor editor) {
            return editor instanceof ObjectPropertyEditor;
        }
    };

    public Fetcher(EditorMap editorMap, Filter<PropertyEditor> ... filters) {
        this.editorMap = editorMap;
        this.filters = (Filter[])ArrayUtils.add(filters, objectPropertiesOnlyFilter);
        this.skipSubPathways = false;
    }

    public void setSkipSubPathways(boolean skipSubPathways) {
        this.skipSubPathways = skipSubPathways;
    }

    public boolean isSkipSubPathways() {
        return this.skipSubPathways;
    }

    public void fetch(BioPAXElement element, Model model) {
        if (!model.containsID(element.getRDFId())) {
            model.add(element);
        }
        Set<BioPAXElement> children = this.fetch(element);
        for (BioPAXElement e : children) {
            if (!model.containsID(e.getRDFId())) {
                model.add(e);
                continue;
            }
            if (!model.contains(e)) {
                throw new AssertionError((Object)("fetch(bioPAXElement, model): found different child objects with the same URI: " + e.getRDFId() + "(replace/merge, or use fetch(bioPAXElement) instead!)"));
            }
        }
    }

    public Set<BioPAXElement> fetch(BioPAXElement element) {
        return this.fetch(element, BioPAXElement.class);
    }

    public Set<BioPAXElement> fetch(BioPAXElement bpe, int depth) {
        if (depth <= 0) {
            throw new IllegalArgumentException("fetch(..), not a positive 'depth':" + depth);
        }
        final HashSet<BioPAXElement> children = new HashSet<BioPAXElement>();
        Traverser traverser = new Traverser(SimpleEditorMap.L3, new Visitor(){

            @Override
            public void visit(BioPAXElement domain, Object range, Model model, PropertyEditor<?, ?> editor) {
                children.add((BioPAXElement)range);
            }
        }, this.filters);
        traverser.traverse(bpe, null);
        if (!children.isEmpty() && --depth > 0) {
            for (BioPAXElement element : new HashSet<BioPAXElement>(children)) {
                Set<BioPAXElement> nextLevelElements = this.fetch(element, depth);
                children.addAll(nextLevelElements);
            }
        }
        children.remove(bpe);
        return children;
    }

    public <T extends BioPAXElement> Set<T> fetch(BioPAXElement element, final Class<T> filterByType) {
        final HashSet children = new HashSet();
        AbstractTraverser traverser = new AbstractTraverser(this.editorMap, (Filter[])this.filters){

            protected void visit(Object range, BioPAXElement domain, Model model, PropertyEditor editor) {
                BioPAXElement bpe = (BioPAXElement)range;
                if (filterByType.isInstance(bpe)) {
                    children.add(bpe);
                }
                if (!Fetcher.this.skipSubPathways || !(range instanceof Pathway)) {
                    this.traverse(bpe, null);
                }
            }
        };
        traverser.traverse(element, null);
        return children;
    }

    public boolean subgraphContains(BioPAXElement root, final String uri, Class<? extends BioPAXElement> type) {
        final AtomicBoolean found = new AtomicBoolean(false);
        AbstractTraverser traverser = new AbstractTraverser(this.editorMap, (Filter[])this.filters){

            protected void visit(Object range, BioPAXElement domain, Model model, PropertyEditor editor) {
                if (range instanceof BioPAXElement && !found.get()) {
                    if (((BioPAXElement)range).getRDFId().equals(uri)) {
                        found.set(true);
                    } else if (!Fetcher.this.skipSubPathways || !(range instanceof Pathway)) {
                        this.traverse((BioPAXElement)range, model);
                    }
                }
            }
        };
        ((Traverser)traverser).traverse(root, null);
        return found.get();
    }
}

